/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.lang;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper {
    public static Method[] getAllMethods(Class<?> cls) {
        ArrayList<Method> list = new ArrayList<Method>();
        ClassHelper.populateAllMethods(cls, list);
        return list.toArray(new Method[0]);
    }

    public static Method getMethod(Class<?> cls, String methodName) throws NoSuchMethodException {
        Method[] methods;
        if (cls == null) {
            throw new NoSuchMethodException(methodName);
        }
        for (Method method : methods = cls.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        try {
            return ClassHelper.getMethod(cls.getSuperclass(), methodName);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException("No method named " + methodName + " in " + cls + " (or super classes)");
        }
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ... params) throws NoSuchMethodException {
        if (cls == null) {
            throw new NoSuchMethodException("Class is null " + methodName);
        }
        Method m = ClassHelper.getDeclaredMethod(cls, methodName, params);
        if (m == null) {
            throw new NoSuchMethodException("No method named " + methodName + " in " + cls + " (or super classes)");
        }
        return m;
    }

    private static Method getDeclaredMethod(Class<?> cls, String methodName, Class<?> ... params) {
        try {
            return cls.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (cls == Object.class) {
                return null;
            }
            return ClassHelper.getDeclaredMethod(cls.getSuperclass(), methodName, params);
        }
    }

    public static Map<String, List<Method>> getAllMethodsMap(Class<?> cls) {
        HashMap<String, List<Method>> methodMap = new HashMap<String, List<Method>>();
        ArrayList<Method> list = new ArrayList<Method>();
        ClassHelper.populateAllMethods(cls, list);
        for (Method method : list) {
            ArrayList<Method> methods = (ArrayList<Method>)methodMap.get(method.getName());
            if (methods == null) {
                methods = new ArrayList<Method>();
                methodMap.put(method.getName(), methods);
            }
            methods.add(method);
        }
        return methodMap;
    }

    private static void populateAllMethods(Class<?> cls, List<Method> methods) {
        if (cls == null) {
            return;
        }
        ClassHelper.populateAllMethods(cls.getSuperclass(), methods);
        for (Method method : cls.getDeclaredMethods()) {
            methods.add(method);
        }
    }

    public static boolean isOverridden(Class<?> icptr, Method method) {
        try {
            Method bottomMethod = ClassHelper.getMethod(icptr, method.getName(), method.getParameterTypes());
            return bottomMethod.getDeclaringClass() != method.getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

