/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.transaction.Transaction;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.TxPolicy;
import org.jboss.ejb3.tx.TxUtil;

public class Ejb3TxPolicy
extends TxPolicy {
    public void throwMandatory(Invocation invocation) {
        throw new EJBTransactionRequiredException(((MethodInvocation)invocation).getActualMethod().toString());
    }

    public void handleExceptionInOurTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable {
        ApplicationException ae = TxUtil.getApplicationException(t.getClass(), invocation);
        if (ae != null) {
            if (ae.rollback()) {
                this.setRollbackOnly(tx);
            }
            throw t;
        }
        if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
            if (t instanceof Error) {
                t = new EJBException(this.formatException("Unexpected Error", t));
            } else if (t instanceof RuntimeException) {
                t = new EJBException((Exception)t);
            } else {
                throw t;
            }
        }
        this.setRollbackOnly(tx);
        throw t;
    }

    public void handleInCallerTx(Invocation invocation, Throwable t, Transaction tx) throws Throwable {
        ApplicationException ae = TxUtil.getApplicationException(t.getClass(), invocation);
        if (ae != null) {
            if (ae.rollback()) {
                this.setRollbackOnly(tx);
            }
            throw t;
        }
        if (!(t instanceof EJBTransactionRolledbackException)) {
            if (t instanceof Error) {
                t = new EJBTransactionRolledbackException(this.formatException("Unexpected Error", t));
            } else if (t instanceof RuntimeException || t instanceof RemoteException) {
                t = new EJBTransactionRolledbackException(t.getMessage(), (Exception)t);
            } else {
                throw t;
            }
        }
        this.setRollbackOnly(tx);
        log.error((Object)t);
        throw t;
    }

    private String formatException(String msg, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (msg != null) {
            pw.println(msg);
        }
        if (t != null) {
            t.printStackTrace(pw);
        }
        return sw.toString();
    }
}

