/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.metadata.javaee.spec;

import javax.persistence.PersistenceContextType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;

/**
 * PersistenceContextReferenceMetaData.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
@XmlType(name="persistence-context-refType")
public class PersistenceContextReferenceMetaData extends ResourceInjectionMetaDataWithDescriptions
   implements MergeableMappedMetaData<PersistenceContextReferenceMetaData>
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 994249685587171979L;

   /** The persistence unit name */
   private String persistenceUnitName;
   
   /** The persistence context type */
   private PersistenceContextType persistenceContextType;
   
   /** The properties */
   private PropertiesMetaData properties;
   
   /**
    * Create a new PersistenceUnitReferenceMetaData.
    */
   public PersistenceContextReferenceMetaData()
   {
      // For serialization
   }

   /**
    * Get the persistenceContextRefName.
    * 
    * @return the persistenceContextRefName.
    */
   public String getPersistenceContextRefName()
   {
      return getName();
   }

   /**
    * Set the persistenceContextRefName.
    * 
    * @param persistenceContextRefName the persistenceContextRefName.
    * @throws IllegalArgumentException for a null persistenceUnitRefName
    */
   public void setPersistenceContextRefName(String persistenceContextRefName)
   {
      setName(persistenceContextRefName);
   }

   /**
    * Get the persistenceUnitName.
    * 
    * @return the persistenceUnitName.
    */
   public String getPersistenceUnitName()
   {
      return persistenceUnitName;
   }

   /**
    * Set the persistenceUnitName.
    * 
    * @param persistenceUnitName the persistenceUnitName.
    * @throws IllegalArgumentException for a null persistenceUnitName
    */
   public void setPersistenceUnitName(String persistenceUnitName)
   {
      if (persistenceUnitName == null)
         throw new IllegalArgumentException("Null persistenceUnitName");
      this.persistenceUnitName = persistenceUnitName;
   }

   /**
    * Get the persistenceContextType.
    * 
    * @return the persistenceContextType.
    */
   public PersistenceContextType getPersistenceContextType()
   {
      return persistenceContextType;
   }

   /**
    * Set the persistenceContextType.
    * 
    * @param persistenceContextType the persistenceContextType.
    * @throws IllegalArgumentException for a null persistenceContextType
    */
   @XmlJavaTypeAdapter(PersistenceContextTypeAdapter.class)
   public void setPersistenceContextType(PersistenceContextType persistenceContextType)
   {
      if (persistenceContextType == null)
         throw new IllegalArgumentException("Null persistenceContextType");
      this.persistenceContextType = persistenceContextType;
   }

   /**
    * Get the properties.
    * 
    * @return the properties.
    */
   public PropertiesMetaData getProperties()
   {
      return properties;
   }

   /**
    * Set the properties.
    * 
    * @param properties the properties.
    * @throws IllegalArgumentException for a null properties
    */
   @XmlElement(name="persistence-property")
   public void setProperties(PropertiesMetaData properties)
   {
      if (properties == null)
         throw new IllegalArgumentException("Null properties");
      this.properties = properties;
   }

   public PersistenceContextReferenceMetaData merge(PersistenceContextReferenceMetaData original)
   {
      PersistenceContextReferenceMetaData merged = new PersistenceContextReferenceMetaData();
      merged.merge(this, original);
      return merged;
   }

   public void merge(PersistenceContextReferenceMetaData override, PersistenceContextReferenceMetaData original)
   {
      super.merge(override, original);
      PersistenceContextReferenceMetaData merged = new PersistenceContextReferenceMetaData();
      merged.merge(this, original);

      if(override != null && override.persistenceUnitName != null)
         persistenceUnitName = override.persistenceUnitName;
      else if(original != null && original.persistenceUnitName != null)
         persistenceUnitName = original.persistenceUnitName;
      if(override != null && override.persistenceContextType != null)
         persistenceContextType = override.persistenceContextType;
      else if(original != null && original.persistenceContextType != null)
         persistenceContextType = original.persistenceContextType;
      if(override != null && override.properties != null)
      {
         if(this.properties == null )
            properties = new PropertiesMetaData();
         properties.addAll(override.properties);
      }
      if(original != null && original.properties != null)
      {
         if(this.properties == null )
            properties = new PropertiesMetaData();
         properties.addAll(original.properties);
      }
   }   
}
