/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.ejb;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRoleRef;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.integration.ejb.SecurityActions;
import org.jboss.security.integration.ejb.SecurityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAuthorizationHelper
extends SecurityHelper {
    public EJBAuthorizationHelper(SecurityContext sc) {
        super(sc);
    }

    public boolean authorize(String ejbName, Method ejbMethod, Principal ejbPrincipal, String invocationInterfaceString, CodeSource ejbCS, Subject callerSubject, RunAs callerRunAs, Set<Principal> methodRoles) {
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        HashMap<String, AuthorizationManager> map = new HashMap<String, AuthorizationManager>();
        map.put("policyRegistration", am);
        String contextID = PolicyContext.getContextID();
        if (contextID == null) {
            throw new IllegalStateException("ContextID is null");
        }
        EJBResource ejbResource = new EJBResource(map);
        ejbResource.setPolicyContextID(contextID);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setEjbName(ejbName);
        ejbResource.setEjbMethod(ejbMethod);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setEjbMethodInterface(invocationInterfaceString);
        ejbResource.setCodeSource(ejbCS);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setCallerSubject(callerSubject);
        ejbResource.setEjbMethodRoles((RoleGroup)new SimpleRoleGroup(methodRoles));
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(callerSubject, (CallbackHandler)sch);
        boolean isAuthorized = false;
        try {
            int check = am.authorize((Resource)ejbResource, callerSubject, callerRoles);
            isAuthorized = check == 1;
            this.authorizationAudit(isAuthorized ? "Success" : "Failure", (Resource)ejbResource, null);
        }
        catch (Exception e) {
            isAuthorized = false;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Error in authorization:", (Throwable)e);
            }
            this.authorizationAudit("Error", (Resource)ejbResource, e);
        }
        return isAuthorized;
    }

    public Principal getCallerPrincipal(RealmMapping rm) {
        Principal caller = SecurityActions.getCallerPrincipal(this.securityContext);
        if (rm != null) {
            caller = rm.getPrincipal(caller);
        }
        return caller;
    }

    public boolean isCallerInRole(String roleName, String ejbName, Principal ejbPrincipal, Set<SecurityRoleRef> securityRoleRefs) {
        boolean isAuthorized = false;
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        if (am == null) {
            throw new IllegalStateException("AuthorizationManager is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyRegistration", am);
        map.put("roleName", roleName);
        map.put("roleRefPermissionCheck", Boolean.TRUE);
        EJBResource ejbResource = new EJBResource(map);
        ejbResource.setPolicyContextID(PolicyContext.getContextID());
        RunAs callerRunAs = this.securityContext.getIncomingRunAs();
        ejbResource.setEjbName(ejbName);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setSecurityRoleReferences(securityRoleRefs);
        Subject subject = null;
        try {
            subject = SecurityActions.getActiveSubject();
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting subject:", (Throwable)e);
            subject = this.securityContext.getUtil().getSubject();
        }
        ejbResource.setCallerSubject(subject);
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(subject, (CallbackHandler)sch);
        try {
            int check = am.authorize((Resource)ejbResource, subject, callerRoles);
            isAuthorized = check == 1;
        }
        catch (Exception e) {
            isAuthorized = false;
            if (log.isTraceEnabled()) {
                log.trace((Object)(roleName + "::isCallerInRole check failed:" + e.getLocalizedMessage()));
            }
            this.authorizationAudit("Error", (Resource)ejbResource, e);
        }
        return isAuthorized;
    }
}

