/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.web;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.SecurityContext;
import org.jboss.security.plugins.SecurityContextAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static Principal getCallerPrincipal(final SecurityContext securityContext) {
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                Object caller = null;
                if (securityContext != null && (caller = securityContext.getIncomingRunAs()) == null) {
                    caller = securityContext.getUtil().getUserPrincipal();
                }
                return caller;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static Exception getContextException() {
        return AccessController.doPrivileged(new PrivilegedAction<Exception>(){
            static final String EX_KEY = "org.jboss.security.exception";

            @Override
            public Exception run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                return (Exception)sc.getData().get(EX_KEY);
            }
        });
    }

    static Subject getActiveSubject() throws PolicyContextException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

            @Override
            public Subject run() throws Exception {
                return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            }
        });
    }
}

