/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interop.jul;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.log4j.Logger;

public class Log4JConversionFilter
implements Filter {
    private Map<String, Logger> loggerCache = new HashMap<String, Logger>();
    private Formatter formatter = new SimpleFormatter();

    @Override
    public boolean isLoggable(LogRecord record) {
        Logger logger = this.getLogger(record);
        if (record.getThrown() != null) {
            this.logWithThrowable(logger, record);
        } else {
            this.logWithoutThrowable(logger, record);
        }
        return false;
    }

    private void logWithThrowable(Logger logger, LogRecord record) {
        int loggedLevel = record.getLevel().intValue();
        String message = this.formatter.formatMessage(record);
        Throwable throwable = record.getThrown();
        if (loggedLevel == Level.SEVERE.intValue()) {
            logger.error((Object)message, throwable);
            return;
        }
        if (loggedLevel == Level.WARNING.intValue()) {
            logger.warn((Object)message, throwable);
            return;
        }
        if (loggedLevel == Level.INFO.intValue() || loggedLevel == Level.CONFIG.intValue()) {
            logger.info((Object)message, throwable);
            return;
        }
        if (loggedLevel == Level.FINE.intValue()) {
            logger.debug((Object)message, throwable);
            return;
        }
        if (loggedLevel == Level.FINER.intValue() || loggedLevel == Level.FINEST.intValue()) {
            logger.trace((Object)message, throwable);
            return;
        }
        logger.info((Object)message, throwable);
    }

    private void logWithoutThrowable(Logger logger, LogRecord record) {
        int loggedLevel = record.getLevel().intValue();
        String message = this.formatter.formatMessage(record);
        if (loggedLevel == Level.SEVERE.intValue()) {
            logger.error((Object)message);
            return;
        }
        if (loggedLevel == Level.WARNING.intValue()) {
            logger.warn((Object)message);
            return;
        }
        if (loggedLevel == Level.INFO.intValue() || loggedLevel == Level.CONFIG.intValue()) {
            logger.info((Object)message);
            return;
        }
        if (loggedLevel == Level.FINE.intValue()) {
            logger.debug((Object)message);
            return;
        }
        if (loggedLevel == Level.FINER.intValue() || loggedLevel == Level.FINEST.intValue()) {
            logger.trace((Object)message);
            return;
        }
        logger.info((Object)message);
    }

    private Logger getLogger(LogRecord record) {
        String loggerName = record.getLoggerName();
        Logger logger = this.loggerCache.get(loggerName);
        if (logger == null) {
            logger = Logger.getLogger((String)loggerName);
            this.loggerCache.put(loggerName, logger);
        }
        return logger;
    }
}

