/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.annotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransactionPropagationType {
    REQUIRED,
    MANDATORY,
    SUPPORTS,
    NEVER;


    public boolean isNewTransactionRequired(boolean transactionActive) {
        try {
            switch (this) {
                case REQUIRED: {
                    return !transactionActive;
                }
                case SUPPORTS: {
                    return false;
                }
                case MANDATORY: {
                    if (!transactionActive) {
                        throw new IllegalStateException("No transaction active on call to MANDATORY method");
                    }
                }
                case NEVER: {
                    if (!transactionActive) break;
                    throw new IllegalStateException("Transaction active on call to NEVER method");
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

