/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.core.validators")
@Intercept(value=InterceptionType.NEVER)
@Scope(value=ScopeType.APPLICATION)
@Install(precedence=0)
public class Validators {
    private Map<Class, ClassValidator> classValidators = Collections.synchronizedMap(new HashMap());

    public ClassValidator getValidator(Class modelClass, String name) {
        ClassValidator result = this.classValidators.get(modelClass);
        if (result == null) {
            result = this.createValidator(modelClass, name);
            this.classValidators.put(modelClass, result);
        }
        return result;
    }

    public <T> ClassValidator<T> getValidator(Class<T> modelClass) {
        return this.getValidator(modelClass);
    }

    protected ClassValidator createValidator(Class modelClass, String name) {
        Component component;
        Component component2 = component = name == null ? null : Component.forName(name);
        if (component == null) {
            java.util.ResourceBundle bundle = ResourceBundle.instance();
            return bundle == null ? new ClassValidator(modelClass) : new ClassValidator(modelClass, bundle);
        }
        return component.getValidator();
    }

    public InvalidValue[] validate(FacesContext context, String propertyExpression, Object value) {
        String propertyName;
        String componentName;
        int dot = propertyExpression.lastIndexOf(46);
        int bracket = propertyExpression.lastIndexOf(91);
        if (dot <= 0 && bracket <= 0) {
            return new InvalidValue[0];
        }
        if (dot > bracket) {
            componentName = propertyExpression.substring(2, dot);
            propertyName = propertyExpression.substring(dot + 1, propertyExpression.length() - 1);
        } else {
            componentName = propertyExpression.substring(2, bracket);
            propertyName = propertyExpression.substring(bracket + 1, propertyExpression.length() - 2);
        }
        String modelExpression = propertyExpression.substring(0, dot) + '}';
        Object model = context.getApplication().createValueBinding(modelExpression).getValue(context);
        ClassValidator validator = this.getValidator(model.getClass(), componentName);
        return validator.getPotentialInvalidValues(propertyName, value);
    }

    public static Validators instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        return (Validators)Component.getInstance(Validators.class, ScopeType.APPLICATION);
    }
}

