/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.model.DataModel;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.framework.PersistenceController;
import org.jboss.seam.jsf.ListDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query<T>
extends PersistenceController<T> {
    private static final Pattern FROM_PATTERN = Pattern.compile("(^|\\s)(from)\\s", 2);
    private static final Pattern ORDER_PATTERN = Pattern.compile("\\s(order)(\\s)+by\\s", 2);
    private static final Pattern WHERE_PATTERN = Pattern.compile("\\s(where)\\s", 2);
    private String ejbql;
    private Integer firstResult;
    private Integer maxResults;
    private List<String> restrictions = new ArrayList<String>(0);
    private String order;
    private DataModel dataModel;
    private String parsedEjbql;
    private List<Expressions.ValueBinding> queryParameters;
    private List<String> parsedRestrictions;
    private List<Expressions.ValueBinding> restrictionParameters;
    private List<Object> queryParameterValues;
    private List<Object> restrictionParameterValues;

    public abstract List getResultList();

    public abstract Object getSingleResult();

    public abstract Long getResultCount();

    @Create
    public void validate() {
        if (this.getEjbql() == null) {
            throw new IllegalStateException("ejbql is null");
        }
    }

    @Transactional
    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListDataModel(this.getResultList());
        }
        return this.dataModel;
    }

    public void refresh() {
        this.clearDataModel();
    }

    public void last() {
        this.setFirstResult((int)this.getLastFirstResult());
        this.clearDataModel();
    }

    public void next() {
        this.setFirstResult(this.getNextFirstResult());
        this.clearDataModel();
    }

    public void previous() {
        this.setFirstResult(this.getPreviousFirstResult());
        this.clearDataModel();
    }

    public void first() {
        this.setFirstResult(0);
        this.clearDataModel();
    }

    protected void clearDataModel() {
        this.dataModel = null;
    }

    @Transactional
    public long getLastFirstResult() {
        return this.getResultCount() / (long)this.getMaxResults().intValue() * (long)this.getMaxResults().intValue();
    }

    public int getNextFirstResult() {
        return (this.getFirstResult() == null ? 0 : this.getFirstResult()) + this.getMaxResults();
    }

    public int getPreviousFirstResult() {
        if (this.getMaxResults() > (this.getFirstResult() == null ? 0 : this.getFirstResult())) {
            return 0;
        }
        return this.getFirstResult() - this.getMaxResults();
    }

    protected void parseEjbql() {
        if (this.parsedEjbql == null) {
            this.queryParameters = new ArrayList<Expressions.ValueBinding>();
            StringTokenizer ejbqlTokens = new StringTokenizer(this.getEjbql(), "#}", true);
            StringBuilder ejbqlBuilder = new StringBuilder();
            while (ejbqlTokens.hasMoreTokens()) {
                String token = ejbqlTokens.nextToken();
                if ("#".equals(token)) {
                    String expression = token + ejbqlTokens.nextToken() + ejbqlTokens.nextToken();
                    this.queryParameters.add(Expressions.instance().createValueBinding(expression));
                    ejbqlBuilder.append(":p").append(this.queryParameters.size());
                    continue;
                }
                ejbqlBuilder.append(token);
            }
            this.parsedEjbql = ejbqlBuilder.toString();
            List<String> restrictionFragments = this.getRestrictions();
            this.parsedRestrictions = new ArrayList<String>(restrictionFragments.size());
            this.restrictionParameters = new ArrayList<Expressions.ValueBinding>(restrictionFragments.size());
            for (String restriction : restrictionFragments) {
                StringTokenizer tokens = new StringTokenizer(restriction, "#}", true);
                StringBuilder builder = new StringBuilder();
                Expressions.ValueBinding valueBinding = null;
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if ("#".equals(token)) {
                        String expression = token + tokens.nextToken() + tokens.nextToken();
                        valueBinding = Expressions.instance().createValueBinding(expression);
                        builder.append(":p").append(this.queryParameters.size() + this.restrictionParameters.size());
                        continue;
                    }
                    builder.append(token);
                }
                if (valueBinding == null) {
                    throw new IllegalArgumentException("no value binding in restriction: " + restriction);
                }
                this.parsedRestrictions.add(builder.toString());
                this.restrictionParameters.add(valueBinding);
            }
        }
    }

    protected String getRenderedEjbql() {
        StringBuilder builder = new StringBuilder().append(this.parsedEjbql);
        for (int i = 0; i < this.getRestrictions().size(); ++i) {
            Object parameterValue = this.restrictionParameters.get(i).getValue();
            if (!this.isRestrictionParameterSet(parameterValue)) continue;
            if (WHERE_PATTERN.matcher(builder).find()) {
                builder.append(" and ");
            } else {
                builder.append(" where ");
            }
            builder.append(this.parsedRestrictions.get(i));
        }
        if (this.getOrder() != null) {
            builder.append(" order by ").append(this.getOrder());
        }
        return builder.toString();
    }

    protected boolean isRestrictionParameterSet(Object parameterValue) {
        return parameterValue != null && !"".equals(parameterValue);
    }

    protected String getCountEjbql() {
        String ejbql = this.getRenderedEjbql();
        Matcher fromMatcher = FROM_PATTERN.matcher(ejbql);
        if (!fromMatcher.find()) {
            throw new IllegalArgumentException("no from clause found in query");
        }
        int fromLoc = fromMatcher.start(2);
        Matcher orderMatcher = ORDER_PATTERN.matcher(ejbql);
        int orderLoc = orderMatcher.find() ? orderMatcher.start(1) : ejbql.length();
        return "select count(*) " + ejbql.substring(fromLoc, orderLoc);
    }

    public String getEjbql() {
        return this.ejbql;
    }

    public void setEjbql(String ejbql) {
        this.ejbql = ejbql;
    }

    public Integer getFirstResult() {
        return this.firstResult;
    }

    public boolean isPreviousExists() {
        return this.getFirstResult() != null && this.getFirstResult() != 0;
    }

    public boolean isNextExists() {
        return this.getResultList() != null && this.getResultList().size() == this.getMaxResults().intValue();
    }

    public void setFirstResult(Integer firstResult) {
        this.firstResult = firstResult;
        this.clearDataModel();
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        this.clearDataModel();
    }

    public List<String> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<String> restrictions) {
        this.restrictions = restrictions;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    protected List<Expressions.ValueBinding> getQueryParameters() {
        return this.queryParameters;
    }

    protected List<Expressions.ValueBinding> getRestrictionParameters() {
        return this.restrictionParameters;
    }

    private static boolean isAnyParameterDirty(List<Expressions.ValueBinding> valueBindings, List<Object> lastParameterValues) {
        if (lastParameterValues == null) {
            return true;
        }
        for (int i = 0; i < valueBindings.size(); ++i) {
            Object lastParameterValue;
            Object parameterValue = valueBindings.get(i).getValue();
            if (parameterValue == (lastParameterValue = lastParameterValues.get(i)) || parameterValue != null && parameterValue.equals(lastParameterValue)) continue;
            return true;
        }
        return false;
    }

    private static List<Object> getParameterValues(List<Expressions.ValueBinding> valueBindings) {
        ArrayList<Object> values = new ArrayList<Object>(valueBindings.size());
        for (int i = 0; i < valueBindings.size(); ++i) {
            values.add(valueBindings.get(i).getValue());
        }
        return values;
    }

    protected void evaluateAllParameters() {
        this.setQueryParameterValues(Query.getParameterValues(this.getQueryParameters()));
        this.setRestrictionParameterValues(Query.getParameterValues(this.getRestrictionParameters()));
    }

    protected boolean isAnyParameterDirty() {
        return Query.isAnyParameterDirty(this.getQueryParameters(), this.getQueryParameterValues()) || Query.isAnyParameterDirty(this.getRestrictionParameters(), this.getRestrictionParameterValues());
    }

    protected List<Object> getQueryParameterValues() {
        return this.queryParameterValues;
    }

    protected void setQueryParameterValues(List<Object> queryParameterValues) {
        this.queryParameterValues = queryParameterValues;
    }

    protected List<Object> getRestrictionParameterValues() {
        return this.restrictionParameterValues;
    }

    protected void setRestrictionParameterValues(List<Object> restrictionParameterValues) {
        this.restrictionParameterValues = restrictionParameterValues;
    }
}

