/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.Interceptor;
import org.jboss.seam.intercept.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamInvocationContext
implements InvocationContext {
    private final EventType eventType;
    private final InvocationContext context;
    private final List<Interceptor> interceptors;
    private final List<Object> userInterceptors;
    int location = 0;

    public SeamInvocationContext(InvocationContext context, EventType type, List<Object> userInterceptors, List<Interceptor> interceptors) {
        this.context = context;
        this.interceptors = interceptors;
        this.userInterceptors = userInterceptors;
        this.eventType = type;
    }

    @Override
    public Object getTarget() {
        return this.context.getTarget();
    }

    @Override
    public Map getContextData() {
        return this.context.getContextData();
    }

    @Override
    public Method getMethod() {
        return this.context.getMethod();
    }

    @Override
    public Object[] getParameters() {
        return this.context.getParameters();
    }

    @Override
    public Object proceed() throws Exception {
        if (this.location == this.interceptors.size()) {
            return this.context.proceed();
        }
        Object userInterceptor = this.userInterceptors.get(this.location);
        Interceptor interceptor = this.interceptors.get(this.location);
        ++this.location;
        switch (this.eventType) {
            case AROUND_INVOKE: {
                return interceptor.aroundInvoke(this, userInterceptor);
            }
            case POST_CONSTRUCT: {
                return interceptor.postConstruct(this, userInterceptor);
            }
            case PRE_DESTORY: {
                return interceptor.preDestroy(this, userInterceptor);
            }
            case PRE_PASSIVATE: {
                return interceptor.prePassivate(this, userInterceptor);
            }
            case POST_ACTIVATE: {
                return interceptor.postActivate(this, userInterceptor);
            }
        }
        throw new IllegalArgumentException("no InvocationType");
    }

    @Override
    public void setParameters(Object[] params) {
        this.context.setParameters(params);
    }
}

