/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.EJB;

@Interceptor
public class BijectionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 4686458105931528659L;
    private static final LogProvider log = Logging.getLogProvider(BijectionInterceptor.class);
    private ThreadLocal<Boolean> reentrant = new ThreadLocal();

    private static boolean isLifecycleMethod(Method method) {
        return method == null || method.isAnnotationPresent(Create.class) || method.isAnnotationPresent(Destroy.class) || method.isAnnotationPresent(EJB.POST_CONSTRUCT) || method.isAnnotationPresent(EJB.PRE_DESTROY) || method.isAnnotationPresent(EJB.PRE_PASSIVATE) || method.isAnnotationPresent(EJB.POST_ACTIVATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object bijectComponent(InvocationContext invocation) throws Exception {
        Observer obs = invocation.getMethod().getAnnotation(Observer.class);
        if (obs != null && !obs.inject()) {
            log.debug("Calling observer without injecting");
            return invocation.proceed();
        }
        if (this.reentrant.get() != null) {
            if (log.isTraceEnabled()) {
                log.trace("reentrant call to component: " + this.getComponent().getName());
            }
            return invocation.proceed();
        }
        this.reentrant.set(true);
        try {
            Object object = this.bijectNonreentrantComponent(invocation);
            return object;
        }
        finally {
            this.reentrant.set(null);
        }
    }

    private Object bijectNonreentrantComponent(InvocationContext invocation) throws Exception {
        if (this.getComponent().needsInjection()) {
            if (log.isTraceEnabled()) {
                log.trace("injecting dependencies of: " + this.getComponent().getName());
            }
            this.getComponent().inject(invocation.getTarget(), !BijectionInterceptor.isLifecycleMethod(invocation.getMethod()));
        }
        Object result = invocation.proceed();
        if (this.getComponent().needsOutjection()) {
            if (log.isTraceEnabled()) {
                log.trace("outjecting dependencies of: " + this.getComponent().getName());
            }
            this.getComponent().outject(invocation.getTarget(), !BijectionInterceptor.isLifecycleMethod(invocation.getMethod()));
        }
        if (this.getComponent().needsInjection()) {
            if (log.isTraceEnabled()) {
                log.trace("disinjecting dependencies of: " + this.getComponent().getName());
            }
            this.getComponent().disinject(invocation.getTarget());
        }
        return result;
    }
}

