/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.microcontainer;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.jboss.resource.connectionmanager.TransactionSynchronizer;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Transactions;
import org.jboss.tm.TransactionManagerLocator;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
import org.jboss.util.naming.NonSerializableFactory;

public class TransactionManagerFactory {
    private static final LogProvider log = Logging.getLogProvider(TransactionManagerFactory.class);

    public TransactionManager getTransactionManager() throws Exception {
        log.info("starting JTA transaction manager");
        InitialContext initialContext = Naming.getInitialContext();
        TransactionManager transactionManager = TransactionManagerLocator.getInstance().locate();
        TransactionSynchronizer.setTransactionManager((TransactionManager)transactionManager);
        NonSerializableFactory.rebind((Context)initialContext, (String)"java:/TransactionManager", (Object)transactionManager);
        ServerVMClientUserTransaction ut = new ServerVMClientUserTransaction(transactionManager);
        NonSerializableFactory.rebind((Context)initialContext, (String)Transactions.getUserTransactionName(), (Object)ut);
        return transactionManager;
    }
}

