//$Id: BasicContext.java,v 1.5 2007/06/21 05:27:27 gavin Exp $
package org.jboss.seam.contexts;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.core.Events;

/**
 * A basic implementation of Context that keeps the state 
 * in a Map.
 * 
 * @author Gavin King
 */
public class BasicContext implements Context
{
   
   private final Map<String, Object> map;
   private final ScopeType scope;
   
   public BasicContext(ScopeType scope)
   {
      this.scope = scope;
      this.map = new HashMap<String, Object>();
   }

   protected BasicContext(ScopeType scope, Map<String, Object> map)
   {
      this.scope = scope;
      this.map = map;
   }

   public ScopeType getType()
   {
      return scope;
   }

   public Object get(Class clazz)
   {
      return get( Component.getComponentName(clazz) );
   }

   public Object get(String name)
   {
      return map.get(name);
   }

   public String[] getNames()
   {
      //yes, I know about the toArray() method,
      //but there is a bug in the RI!
      Set<String> keySet = map.keySet();
      String[] array = new String[ keySet.size() ];
      int i=0;
      for (String key: keySet)
      {
         array[i++] = key;
      }
      return array;
   }

   public boolean isSet(String name)
   {
      return map.containsKey(name);
   }

   public void remove(String name)
   {
      if ( Events.exists() ) Events.instance().raiseEvent("org.jboss.seam.preRemoveVariable." + name);
      map.remove(name);
      if ( Events.exists() ) Events.instance().raiseEvent("org.jboss.seam.postRemoveVariable." + name);
   }

   public void set(String name, Object value)
   {
      if ( Events.exists() ) Events.instance().raiseEvent("org.jboss.seam.preSetVariable." + name);
      map.put(name, value);
      if ( Events.exists() ) Events.instance().raiseEvent("org.jboss.seam.postSetVariable." + name);
   }

   public void flush() {}

   @Override
   public String toString()
   {
      return "BasicContext(" + scope + ")";
   }

}
