/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Strings;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Startup
@Name(value="org.jboss.seam.international.localeConfig")
@Install(value=false, precedence=0, classDependencies={"javax.faces.context.FacesContext"})
public class LocaleConfig {
    private String defaultLocale;
    private List<String> supportedLocales;
    private static final LogProvider log = Logging.getLogProvider(LocaleConfig.class);

    @Create
    public void initLocaleConfig() {
        List<String> supportedAsStrings;
        int numSupported;
        Application application = this.getApplication();
        if (application == null) {
            return;
        }
        String defaultAsString = this.getDefaultLocale();
        if (defaultAsString != null) {
            application.setDefaultLocale(this.getLocaleFromString(defaultAsString));
        }
        int n = numSupported = (supportedAsStrings = this.getSupportedLocales()) != null ? supportedAsStrings.size() : 0;
        if (numSupported > 0) {
            LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>(numSupported);
            for (String supportedAsString : supportedAsStrings) {
                locales.add(this.getLocaleFromString(supportedAsString));
            }
            application.setSupportedLocales(locales);
        }
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
        log.debug("Default locale was set to " + this.defaultLocale);
    }

    public List<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(List<String> supportedLocales) {
        this.supportedLocales = supportedLocales;
        log.debug("Supported locales are " + this.supportedLocales);
    }

    public static LocaleConfig instance() {
        return (LocaleConfig)Component.getInstance(LocaleConfig.class, ScopeType.APPLICATION);
    }

    private Locale getLocaleFromString(String localeString) {
        String variant;
        if (localeString == null || localeString.length() < 2) {
            throw new IllegalArgumentException("Invalid locale string: " + localeString);
        }
        StringTokenizer tokens = new StringTokenizer(localeString, "-_");
        String language = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        String country = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        String string = variant = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        if (!Strings.isEmpty(variant)) {
            return new Locale(language, country, variant);
        }
        if (!Strings.isEmpty(country)) {
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    private Application getApplication() {
        try {
            ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            return factory.getApplication();
        }
        catch (IllegalStateException e) {
            log.warn("JSF is not properly initialized, see http://jira.jboss.org/jira/browse/JBSEAM-4401");
            return null;
        }
    }
}

