/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface IdentityStore {
    public boolean supportsFeature(Feature var1);

    public boolean createUser(String var1, String var2);

    public boolean createUser(String var1, String var2, String var3, String var4);

    public boolean deleteUser(String var1);

    public boolean enableUser(String var1);

    public boolean disableUser(String var1);

    public boolean isUserEnabled(String var1);

    public boolean changePassword(String var1, String var2);

    public boolean userExists(String var1);

    public boolean createRole(String var1);

    public boolean grantRole(String var1, String var2);

    public boolean revokeRole(String var1, String var2);

    public boolean deleteRole(String var1);

    public boolean roleExists(String var1);

    public boolean addRoleToGroup(String var1, String var2);

    public boolean removeRoleFromGroup(String var1, String var2);

    public List<String> listUsers();

    public List<String> listUsers(String var1);

    public List<String> listRoles();

    public List<String> listGrantableRoles();

    public List<String> getGrantedRoles(String var1);

    public List<String> getImpliedRoles(String var1);

    public List<String> getRoleGroups(String var1);

    public List<Principal> listMembers(String var1);

    public boolean authenticate(String var1, String var2);

    public static class FeatureSet {
        private Set<Feature> features;

        public FeatureSet() {
            this(null);
        }

        public FeatureSet(Set<Feature> features) {
            this.features = features != null ? features : new HashSet<Feature>();
        }

        public Set<Feature> getFeatures() {
            return this.features;
        }

        public boolean supports(Feature feature) {
            return this.features.contains((Object)feature);
        }

        public void addFeature(Feature feature) {
            this.features.add(feature);
        }

        public void removeFeature(Feature feature) {
            this.features.remove((Object)feature);
        }

        public void enableAll() {
            for (Feature f : Feature.values()) {
                this.addFeature(f);
            }
        }
    }

    public static enum Feature {
        createUser,
        deleteUser,
        enableUser,
        disableUser,
        changePassword,
        createRole,
        deleteRole,
        grantRole,
        revokeRole;

    }
}

