/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.SimplePrincipal;
import org.jboss.seam.security.permission.JpaPermissionStore;
import org.jboss.seam.security.permission.Permission;
import org.jboss.seam.security.permission.PermissionResolver;
import org.jboss.seam.security.permission.PermissionStore;
import org.jboss.seam.security.permission.RuleBasedPermissionResolver;

@Name(value="org.jboss.seam.security.persistentPermissionResolver")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(precedence=0)
@Startup
public class PersistentPermissionResolver
implements PermissionResolver,
Serializable {
    private PermissionStore permissionStore;
    private static final LogProvider log = Logging.getLogProvider(PersistentPermissionResolver.class);

    @Create
    public void create() {
        this.initPermissionStore();
    }

    protected void initPermissionStore() {
        if (this.permissionStore == null) {
            this.permissionStore = (PermissionStore)Component.getInstance(JpaPermissionStore.class, true);
        }
        if (this.permissionStore == null) {
            log.warn("no permission store available - please install a PermissionStore with the name '" + Seam.getComponentName(JpaPermissionStore.class) + "' if persistent permissions are required.");
        }
    }

    public PermissionStore getPermissionStore() {
        return this.permissionStore;
    }

    public void setPermissionStore(PermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @Override
    public boolean hasPermission(Object target, String action) {
        if (this.permissionStore == null) {
            return false;
        }
        Identity identity = Identity.instance();
        if (!identity.isLoggedIn()) {
            return false;
        }
        List<Permission> permissions = this.permissionStore.listPermissions(target, action);
        String username = identity.getPrincipal() != null ? identity.getPrincipal().getName() : null;
        for (Permission permission : permissions) {
            RuleBasedPermissionResolver resolver;
            Role role;
            if (username != null && permission.getRecipient() instanceof SimplePrincipal && username.equals(permission.getRecipient().getName())) {
                return true;
            }
            if (!(permission.getRecipient() instanceof Role) || !((role = (Role)permission.getRecipient()).isConditional() ? (resolver = RuleBasedPermissionResolver.instance()).checkConditionalRole(role.getName(), target, action) : identity.hasRole(role.getName()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void filterSetByAction(Set<Object> targets, String action) {
        if (this.permissionStore == null) {
            return;
        }
        Identity identity = Identity.instance();
        if (!identity.isLoggedIn()) {
            return;
        }
        List<Permission> permissions = this.permissionStore.listPermissions(targets, action);
        String username = identity.getPrincipal().getName();
        Iterator<Object> iter = targets.iterator();
        block0: while (iter.hasNext()) {
            Object target = iter.next();
            for (Permission permission : permissions) {
                if (!permission.getTarget().equals(target)) continue;
                if (permission.getRecipient() instanceof SimplePrincipal && username.equals(permission.getRecipient().getName())) {
                    iter.remove();
                    continue block0;
                }
                if (!(permission.getRecipient() instanceof Role)) continue;
                Role role = (Role)permission.getRecipient();
                if (role.isConditional()) {
                    RuleBasedPermissionResolver resolver = RuleBasedPermissionResolver.instance();
                    if (!resolver.checkConditionalRole(role.getName(), target, action)) continue;
                    iter.remove();
                    continue block0;
                }
                if (!identity.hasRole(role.getName())) continue;
                iter.remove();
                continue block0;
            }
        }
    }
}

