/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.jms.ManagedQueueSender;
import org.jboss.seam.log.Log;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Name(value="org.jboss.seam.jms.queueConnection")
@Install(precedence=0, genericDependencies={ManagedQueueSender.class})
public class QueueConnection {
    @Logger
    private Log log;
    private String queueConnectionFactoryJndiName = "UIL2ConnectionFactory";
    private javax.jms.QueueConnection queueConnection;

    public String getQueueConnectionFactoryJndiName() {
        return this.queueConnectionFactoryJndiName;
    }

    public void setQueueConnectionFactoryJndiName(String jndiName) {
        this.queueConnectionFactoryJndiName = jndiName;
    }

    @Create
    public void init() throws NamingException, JMSException {
        this.queueConnection = this.getQueueConnectionFactory().createQueueConnection();
        this.queueConnection.start();
    }

    @Destroy
    public void destroy() throws JMSException {
        try {
            this.queueConnection.stop();
        }
        catch (IllegalStateException e) {
            this.log.warn((Object)"queueSession.stop() called during @Destroy in an invalid context for this container. Msg={0}", e.getMessage());
        }
        this.queueConnection.close();
    }

    private QueueConnectionFactory getQueueConnectionFactory() throws NamingException {
        return (QueueConnectionFactory)Naming.getInitialContext().lookup(this.queueConnectionFactoryJndiName);
    }

    @Unwrap
    public javax.jms.QueueConnection getQueueConnection() {
        return this.queueConnection;
    }

    public static javax.jms.QueueConnection instance() {
        return (javax.jms.QueueConnection)Component.getInstance(QueueConnection.class);
    }

    public String toString() {
        return "QueueConnection(" + this.queueConnectionFactoryJndiName + ")";
    }
}

