/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.type.Type;
import org.jboss.seam.Entity;
import org.jboss.seam.security.EntityAction;
import org.jboss.seam.security.EntityPermissionChecker;

public class HibernateSecurityInterceptor
extends EmptyInterceptor {
    private Interceptor wrappedInterceptor;

    public HibernateSecurityInterceptor(Interceptor wrappedInterceptor) {
        this.wrappedInterceptor = wrappedInterceptor;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        try {
            EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.READ);
        }
        catch (Entity.NotEntityException notEntityException) {
            // empty catch block
        }
        return this.wrappedInterceptor != null ? this.wrappedInterceptor.onLoad(entity, id, state, propertyNames, types) : false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        try {
            EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.DELETE);
        }
        catch (Entity.NotEntityException notEntityException) {
            // empty catch block
        }
        if (this.wrappedInterceptor != null) {
            this.wrappedInterceptor.onDelete(entity, id, state, propertyNames, types);
        }
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        try {
            EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.UPDATE);
        }
        catch (Entity.NotEntityException notEntityException) {
            // empty catch block
        }
        return this.wrappedInterceptor != null ? this.wrappedInterceptor.onFlushDirty(entity, id, currentState, previousState, propertyNames, types) : false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        try {
            EntityPermissionChecker.instance().checkEntityPermission(entity, EntityAction.INSERT);
        }
        catch (Entity.NotEntityException notEntityException) {
            // empty catch block
        }
        return this.wrappedInterceptor != null ? this.wrappedInterceptor.onSave(entity, id, state, propertyNames, types) : false;
    }
}

