/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Client;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.VirtualHost;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.service.LogService;
import org.restlet.service.StatusService;
import org.restlet.util.ClientList;
import org.restlet.util.Engine;
import org.restlet.util.Helper;
import org.restlet.util.ServerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends Restlet {
    private ClientList clients;
    private ServerList servers;
    private List<VirtualHost> hosts;
    private VirtualHost defaultHost;
    private Helper helper;
    private LogService logService;
    private StatusService statusService;

    public Component() {
        super(null);
        if (Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this);
            if (this.helper != null) {
                this.setContext(this.helper.createContext(this.getClass().getCanonicalName()));
                this.hosts = null;
                this.defaultHost = new VirtualHost(this.getContext());
                this.logService = null;
                this.statusService = null;
            }
        }
    }

    public ClientList getClients() {
        if (this.clients == null) {
            this.clients = new ClientList(this.getContext());
        }
        return this.clients;
    }

    public ServerList getServers() {
        if (this.servers == null) {
            this.servers = new ServerList(this.getContext(), this);
        }
        return this.servers;
    }

    @Override
    public void start() throws Exception {
        if (this.isStopped()) {
            if (this.clients != null) {
                for (Client client : this.clients) {
                    client.start();
                }
            }
            if (this.servers != null) {
                for (Server server : this.servers) {
                    server.start();
                }
            }
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
            super.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().stop();
        }
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.stop();
            }
        }
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.stop();
            }
        }
        super.stop();
    }

    public VirtualHost getDefaultHost() {
        return this.defaultHost;
    }

    private Helper getHelper() {
        return this.helper;
    }

    public List<VirtualHost> getHosts() {
        if (this.hosts == null) {
            this.hosts = new ArrayList<VirtualHost>();
        }
        return this.hosts;
    }

    public LogService getLogService() {
        if (this.logService == null) {
            this.logService = new LogService(true);
            this.logService.setLoggerName(this.getClass().getCanonicalName() + " (" + this.hashCode() + ")");
        }
        return this.logService;
    }

    public StatusService getStatusService() {
        if (this.statusService == null) {
            this.statusService = new StatusService(true);
        }
        return this.statusService;
    }

    @Override
    public void handle(Request request, Response response) {
        this.init(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }
}

