/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.logging.Logger;
import org.richfaces.test.staging.ServerLogger;
import org.richfaces.test.staging.ServerResource;
import org.richfaces.test.staging.ServerResourcePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerResource
implements ServerResource {
    private static final Logger log = ServerLogger.RESOURCE.getLogger();

    @Override
    public InputStream getAsStream() throws IOException {
        URL url = this.getURL();
        if (url != null) {
            URLConnection connection = url.openConnection();
            try {
                connection.setUseCaches(false);
            }
            catch (IllegalArgumentException e) {
                log.info("RESOURCE_NOT_CACHEABLE");
            }
            return connection.getInputStream();
        }
        return null;
    }

    @Override
    public void addResource(ServerResourcePath path, ServerResource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerResource getResource(ServerResourcePath path) {
        if (null == path) {
            throw new NullPointerException();
        }
        if (path.isFile()) {
            return this;
        }
        return null;
    }

    @Override
    public Set<String> getPaths() {
        return null;
    }
}

