/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.util.regex.Pattern;

public class ServerResourcePath {
    private static final Pattern SLASH = Pattern.compile("/");
    public static final ServerResourcePath WEB_INF = new ServerResourcePath("/WEB-INF/");
    public static final ServerResourcePath META_INF = new ServerResourcePath("/META-INF/");
    public static final ServerResourcePath WEB_XML = new ServerResourcePath("/WEB-INF/web.xml");
    public static final ServerResourcePath FACES_CONFIG = new ServerResourcePath("/WEB-INF/faces-config.xml");
    private final String[] pathElements;

    private ServerResourcePath(String[] pathElements) {
        this.pathElements = pathElements;
    }

    public ServerResourcePath(String path) {
        if (null == path) {
            throw new NullPointerException();
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String[] split = SLASH.split(path);
        if (split.length > 1 && path.endsWith("/")) {
            this.pathElements = new String[split.length + 1];
            System.arraycopy(split, 0, this.pathElements, 0, split.length);
        } else {
            this.pathElements = split;
        }
    }

    public boolean isFile() {
        return this.pathElements.length <= 1 || null == this.pathElements[1];
    }

    public String getNextElementName() {
        if (this.pathElements.length > 1) {
            String name = this.pathElements[1];
            if (this.pathElements.length > 2) {
                name = name + '/';
            }
            return name;
        }
        return null;
    }

    public ServerResourcePath getNextPath() {
        if (this.pathElements.length > 1 && null != this.pathElements[1]) {
            String[] nextElenemts = new String[this.pathElements.length - 1];
            System.arraycopy(this.pathElements, 1, nextElenemts, 0, nextElenemts.length);
            return new ServerResourcePath(nextElenemts);
        }
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.pathElements.length > 1) {
            for (int i = 1; i < this.pathElements.length; ++i) {
                String element = this.pathElements[i];
                str.append("/");
                if (null == element) continue;
                str.append(element);
            }
        } else {
            str.append("/");
        }
        return str.toString();
    }
}

