/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.richfaces.test.staging.ServerResource;
import org.richfaces.test.staging.ServerResourcePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerResourcesDirectory
implements ServerResource {
    private final Map<String, ServerResource> children = new HashMap<String, ServerResource>();

    @Override
    public void addResource(ServerResourcePath path, ServerResource resource) {
        if (null == path || path.isFile()) {
            throw new IllegalArgumentException();
        }
        if (path.getNextPath().isFile()) {
            this.children.put(path.getNextElementName(), resource);
        } else {
            ServerResource nextDirectory = this.children.get(path.getNextElementName());
            if (null == nextDirectory) {
                nextDirectory = new ServerResourcesDirectory();
                this.children.put(path.getNextElementName(), nextDirectory);
            }
            nextDirectory.addResource(path.getNextPath(), resource);
        }
    }

    @Override
    public ServerResource getResource(ServerResourcePath path) {
        if (null == path) {
            throw new NullPointerException();
        }
        ServerResource resource = null;
        if (path.isFile()) {
            resource = this;
        } else {
            resource = this.children.get(path.getNextElementName());
            if (!path.getNextPath().isFile() && null != resource) {
                resource = resource.getResource(path.getNextPath());
            }
        }
        return resource;
    }

    @Override
    public InputStream getAsStream() {
        return null;
    }

    @Override
    public Set<String> getPaths() {
        return this.children.keySet();
    }

    @Override
    public URL getURL() {
        return null;
    }
}

