/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.richfaces.test.TestException;
import org.richfaces.test.staging.HttpMethod;
import org.richfaces.test.staging.RequestChain;
import org.richfaces.test.staging.ServerLogger;
import org.richfaces.test.staging.StagingHttpRequest;
import org.richfaces.test.staging.StagingHttpResponse;
import org.richfaces.test.staging.StagingServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingConnection {
    private static final Logger log = ServerLogger.SERVER.getLogger();
    private final StagingServer server;
    final URL url;
    private ConnectionRequest request;
    private ConnectionResponse response;
    private final RequestChain servlet;
    private HttpMethod method = HttpMethod.GET;
    private static final Cookie[] COOKIE = new Cookie[0];
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private Map<String, String[]> requestParameters = new HashMap<String, String[]>();
    private final String pathInfo;
    private final String servletPath;
    private boolean finished = false;
    private boolean started = false;
    private String queryString;
    private HttpServletRequest requestProxy;
    private HttpServletResponse responseProxy;

    StagingConnection(StagingServer localServer, URL url) {
        ClassLoader loader;
        this.server = localServer;
        this.url = url;
        String path = url.getPath();
        this.servlet = localServer.getServlet(path);
        if (null == this.servlet) {
            throw new IllegalArgumentException();
        }
        this.pathInfo = this.servlet.getPathInfo(path);
        this.servletPath = this.servlet.getServletPath(path);
        this.request = new ConnectionRequest();
        this.response = new ConnectionResponse();
        this.request.setAttribute("javax.servlet.include.path_info", this.pathInfo);
        this.request.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
        this.setQueryString(url.getQuery());
        if (null != this.getQueryString()) {
            this.parseFormParameters(this.queryString);
        }
        if (null == (loader = Thread.currentThread().getContextClassLoader())) {
            loader = this.getClass().getClassLoader();
        }
        this.requestProxy = (HttpServletRequest)Proxy.newProxyInstance(loader, new Class[]{HttpServletRequest.class}, this.server.getInvocationHandler(this.request));
        this.responseProxy = (HttpServletResponse)Proxy.newProxyInstance(loader, new Class[]{HttpServletResponse.class}, this.server.getInvocationHandler(this.response));
    }

    public void parseFormParameters(String queryString) {
        String[] queryParams = queryString.split("&");
        for (int i = 0; i < queryParams.length; ++i) {
            try {
                String par = queryParams[i];
                int eqIndex = par.indexOf(61);
                if (eqIndex >= 0) {
                    String name = URLDecoder.decode(par.substring(0, eqIndex), this.request.getCharacterEncoding());
                    String value = URLDecoder.decode(par.substring(eqIndex + 1), this.request.getCharacterEncoding());
                    this.addRequestParameter(name, value);
                    continue;
                }
                this.addRequestParameter(URLDecoder.decode(par, this.request.getCharacterEncoding()), null);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new TestException(e);
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void execute() {
        if (this.isStarted() || this.isFinished()) {
            throw new TestException("request have already been executed");
        }
        this.start();
        try {
            this.servlet.execute((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new TestException("Error execute request ", e);
        }
        catch (IOException e) {
            throw new TestException("IO Error during request execution", e);
        }
        finally {
            this.finish();
        }
    }

    public void finish() {
        this.server.requestFinished((ServletRequest)this.request);
        this.finished = true;
    }

    public void start() {
        log.fine("start " + (Object)((Object)this.getRequestMethod()) + " request processing for file " + this.url.getFile());
        log.fine("request parameters: " + this.requestParameters);
        this.server.requestStarted((ServletRequest)this.request);
        this.started = true;
    }

    public HttpMethod getRequestMethod() {
        return this.method;
    }

    public void setRequestMethod(HttpMethod method) {
        this.method = method;
    }

    public URL getUrl() {
        return this.url;
    }

    public void addRequestParameter(String name, String value) {
        String[] values = this.requestParameters.get(name);
        if (null == values) {
            values = new String[1];
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            values = newValues;
        }
        values[values.length - 1] = value;
        this.requestParameters.put(name, values);
    }

    public String getContentAsString() {
        byte[] streamContent;
        String content = this.response.getWriterContent();
        if (null == content && null != (streamContent = this.response.getStreamContent())) {
            String encoding = this.response.getCharacterEncoding();
            if (null != encoding) {
                try {
                    content = new String(streamContent, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new TestException(e);
                }
            } else {
                content = new String(streamContent);
            }
        }
        return content;
    }

    public byte[] getResponseBody() {
        byte[] content = this.response.getStreamContent();
        if (null == content) {
            String writerContent = this.response.getWriterContent();
            if (null != writerContent) {
                try {
                    content = writerContent.getBytes(this.response.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    content = writerContent.getBytes();
                }
            } else {
                content = new byte[]{};
            }
        }
        return content;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public HttpServletRequest getRequest() {
        return this.requestProxy;
    }

    public HttpServletResponse getResponse() {
        return this.responseProxy;
    }

    public String getResponseCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public String getResponseContentType() {
        return this.response.getContentType();
    }

    public int getResponseStatus() {
        return this.response.getStatus();
    }

    public String getErrorMessage() {
        return this.response.getErrorMessage();
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String[]> getResponseHeaders() {
        return this.response.getHeaders();
    }

    public void setRequestCharacterEncoding(String charset) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(charset);
    }

    public void setRequestBody(String body) {
        this.request.setRequestBody(body);
    }

    public void setRequestContentType(String contentType) {
        this.request.setContentType(contentType);
    }

    public void addRequestHeaders(Map<String, String> headers) {
        this.request.addHeaders(headers);
    }

    public int getResponseContentLength() {
        return this.response.getContentLength();
    }

    private class ConnectionResponse
    extends StagingHttpResponse {
        private ConnectionResponse() {
        }

        public void addCookie(Cookie cookie) {
            StagingConnection.this.cookies.add(cookie);
        }
    }

    private class ConnectionRequest
    extends StagingHttpRequest {
        private ConnectionRequest() {
        }

        public Cookie[] getCookies() {
            return StagingConnection.this.cookies.toArray(COOKIE);
        }

        public String getMethod() {
            return StagingConnection.this.method.toString();
        }

        public String getServletPath() {
            return StagingConnection.this.servletPath;
        }

        public String getPathInfo() {
            return StagingConnection.this.pathInfo;
        }

        public String getQueryString() {
            return StagingConnection.this.queryString;
        }

        public String getRequestURI() {
            return StagingConnection.this.url.getPath();
        }

        public String getServerName() {
            return StagingConnection.this.url.getHost();
        }

        public int getLocalPort() {
            int port = StagingConnection.this.url.getPort();
            if (port < 0) {
                port = super.getLocalPort();
            }
            return port;
        }

        public String getParameter(String name) {
            String[] values = (String[])StagingConnection.this.requestParameters.get(name);
            if (null != values && values.length > 0) {
                return values[0];
            }
            return null;
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(StagingConnection.this.requestParameters);
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(StagingConnection.this.requestParameters.keySet());
        }

        public String[] getParameterValues(String name) {
            return (String[])StagingConnection.this.requestParameters.get(name);
        }

        public HttpSession getSession() {
            return StagingConnection.this.server.getSession();
        }

        public HttpSession getSession(boolean create) {
            return StagingConnection.this.server.getSession(create);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            RequestChain dispatchedServlet;
            RequestDispatcher dispatcher = null;
            if (!path.startsWith("/")) {
                try {
                    URL absoluteUrl = new URL(StagingConnection.this.url, path);
                    path = absoluteUrl.getFile();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            if (null != (dispatchedServlet = StagingConnection.this.server.getServlet(path))) {
                dispatcher = new RequestDispatcher(){

                    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                        response.reset();
                        dispatchedServlet.execute(request, response);
                    }

                    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                        dispatchedServlet.execute(request, response);
                    }
                };
            }
            return dispatcher;
        }

        protected void attributeAdded(String name, Object o) {
            StagingConnection.this.server.requestAttributeAdded((ServletRequest)this, name, o);
        }

        protected void attributeRemoved(String name, Object removed) {
            StagingConnection.this.server.requestAttributeRemoved((ServletRequest)this, name, removed);
        }

        protected void attributeReplaced(String name, Object o) {
            StagingConnection.this.server.requestAttributeReplaced((ServletRequest)this, name, o);
        }
    }
}

