/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.richfaces.test.staging.NotImplementedException;

abstract class StagingHttpSession
implements HttpSession {
    private static final int DEFAULT_INACTIVE_TIME = 30;
    public static final String SESSION_ID = "1234567890";
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final long creationTime = System.currentTimeMillis();
    private volatile int inactiveTime = 30;
    private boolean valid = true;

    void destroy() {
        this.unboundAttributes();
    }

    private void unboundAttributes() {
        for (String name : this.getValueNames()) {
            this.removeAttribute(name);
        }
    }

    public Object getAttribute(String name) {
        this.checkValid();
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        this.checkValid();
        return Collections.enumeration(this.attributes.keySet());
    }

    public long getCreationTime() {
        this.checkValid();
        return this.creationTime;
    }

    public String getId() {
        return SESSION_ID;
    }

    public long getLastAccessedTime() {
        this.checkValid();
        return 0L;
    }

    public int getMaxInactiveInterval() {
        return this.inactiveTime;
    }

    public HttpSessionContext getSessionContext() {
        throw new NotImplementedException("Session context is not implemented");
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        this.checkValid();
        ArrayList<String> names = new ArrayList<String>(this.attributes.keySet());
        return names.toArray(new String[names.size()]);
    }

    public void invalidate() {
        this.checkValid();
        this.destroy();
        this.valid = false;
    }

    protected void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("Session have been invalidated");
        }
    }

    public boolean isNew() {
        this.checkValid();
        return false;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkValid();
        Object removed = this.attributes.remove(name);
        if (null != removed) {
            this.removedFromSession(name, removed);
        }
    }

    protected void removedFromSession(String name, Object removed) {
        HttpSessionBindingEvent sessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, name, removed);
        if (removed instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)removed;
            listener.valueUnbound(sessionBindingEvent);
        }
        this.valueUnbound(sessionBindingEvent);
    }

    protected abstract void valueUnbound(HttpSessionBindingEvent var1);

    protected void boundToSession(String name, Object value) {
        HttpSessionBindingEvent sessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
            listener.valueBound(sessionBindingEvent);
        }
        this.valueBound(sessionBindingEvent);
    }

    protected abstract void valueBound(HttpSessionBindingEvent var1);

    protected void replacedInSession(String name, Object oldValue, Object value) {
        HttpSessionBindingListener listener;
        HttpSessionBindingEvent sessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(sessionBindingEvent);
        }
        if (value instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)value;
            listener.valueBound(sessionBindingEvent);
        }
        this.valueReplaced(sessionBindingEvent);
    }

    protected abstract void valueReplaced(HttpSessionBindingEvent var1);

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkValid();
        if (null == value) {
            this.removeAttribute(name);
        } else {
            Object oldValue = this.attributes.put(name, value);
            if (null != oldValue) {
                this.replacedInSession(name, oldValue, value);
            } else {
                this.boundToSession(name, value);
            }
        }
    }

    public void setMaxInactiveInterval(int interval) {
        this.inactiveTime = interval;
    }
}

