package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIInplaceSelect;

public class HtmlInplaceSelect extends UIInplaceSelect{

final public static  String COMPONENT_FAMILY = "org.richfaces.InplaceSelect";

final public static  String COMPONENT_TYPE = "org.richfaces.InplaceSelect";

/*
* Defines custom cancel icon
*/
private  String _cancelControlIcon = null;

/*
* CSS style class for changed state
*/
private  String _changedClass = null;

/*
* CSS style class for controls
*/
private  String _controlClass = null;

/*
* CSS style class for hovered
                                        control
*/
private  String _controlHoverClass = null;

/*
* CSS style class for controls
                                        pressed
*/
private  String _controlPressClass = null;

/*
* The attribute positions the controls
                                                  horizontally. Possible values are
                                                  "right","center","left".
                                                  Default value is "right".
*/
private  String _controlsHorizontalPosition = null;

/*
* The attribute positions the controls
                                                  vertically. Possible values are
                                                  "bottom","center" and "top". Default value is "center"
*/
private  String _controlsVerticalPosition = null;

/*
* The attribute is used to display text while
                                                  value is undefined
*/
private  String _defaultLabel = null;

/*
* CSS style class for edit state
*/
private  String _editClass = null;

/*
* The attribute provides an option to assign an
                                                  JavaScript action that initiates the change of the
                                                  state. Default value is
                                                  "onclick".
*/
private  String _editEvent = null;

/*
* The attribute activates edit state once Tab key
                                                  pressed. Default value is
                                                  "true".
*/
private  boolean _editOnTab = true;

private  boolean _editOnTabSet = false;

/*
* A localized user presentable name for this component.
*/
private  String _label = null;

/*
* Defines how the component is displayed in the
                                                  layout. Possible values are
                                                  "block",
                                                  "inline". Default value is
                                                  "inline".
*/
private  String _layout = null;

/*
* The attribute defines the height of option
                                                  list. Default value is "200px".
*/
private  String _listHeight = null;

/*
* The attribute defines the width of option list.
                                                  Default value is "200px".
*/
private  String _listWidth = null;

/*
* Sets the maximum width of the select element.
                                                  Default value is "200px".
*/
private  String _maxSelectWidth = null;

/*
* Sets the minimum width of the select element.
                                                  Default value is "100px".
*/
private  String _minSelectWidth = null;

/*
* HTML: script expression; the element lost the
                                                  focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was
                                                  changed
*/
private  String _onchange = null;

/*
* The clientside script method to be called when the element is clicked
*/
private  String _onclick = null;

/*
* The client side script method to be called when the element is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: script expression; edit state is
                                                  activated
*/
private  String _oneditactivated = null;

/*
* The attributes provide a possibility to assign
                                                  JavaScript on edit state activation
*/
private  String _oneditactivation = null;

/*
* HTML: script expression; the element got the
                                                  focus
*/
private  String _onfocus = null;

/*
* HTML: script expression; the element lost the
                                                  focus
*/
private  String _oninputblur = null;

/*
* HTML: a script expression; a pointer button is
                                                  clicked
*/
private  String _oninputclick = null;

/*
* HTML: a script expression; a pointer button is
                                                  double-clicked
*/
private  String _oninputdblclick = null;

/*
* HTML: script expression; the element got the
                                                  focus
*/
private  String _oninputfocus = null;

/*
* HTML: a script expression; a key is pressed
                                                  down
*/
private  String _oninputkeydown = null;

/*
* HTML: a script expression; a key is pressed and
                                                  released
*/
private  String _oninputkeypress = null;

/*
* HTML: a script expression; a key is
                                        released
*/
private  String _oninputkeyup = null;

/*
* HTML: script expression; a pointer button is
                                                  pressed down
*/
private  String _oninputmousedown = null;

/*
* HTML: a script expression; a pointer is moved
                                                  within
*/
private  String _oninputmousemove = null;

/*
* HTML: a script expression; a pointer is moved
                                                  away
*/
private  String _oninputmouseout = null;

/*
* HTML: a script expression; a pointer is moved
                                                  onto
*/
private  String _oninputmouseover = null;

/*
* HTML: script expression; a pointer button is
                                                  released
*/
private  String _oninputmouseup = null;

/*
* The client side script method to be called when a key is pressed down over the element
*/
private  String _onkeydown = null;

/*
* The client side script method to be called when a key is pressed over the element and released
*/
private  String _onkeypress = null;

/*
* The client side script method to be called when a key is released
*/
private  String _onkeyup = null;

/*
* The client side script method to be called when a mouse button is pressed down over the element
*/
private  String _onmousedown = null;

/*
* The client side script method to be called when a pointer is moved within the element
*/
private  String _onmousemove = null;

/*
* The client side script method to be called when a pointer is moved away from the element
*/
private  String _onmouseout = null;

/*
* The client side script method to be called when a pointer is moved onto the element
*/
private  String _onmouseover = null;

/*
* The client side script method to be called when a mouse button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; the onselect event
                                                  occurs when you select some menu
                                        item
*/
private  String _onselect = null;

/*
* HTML: script expression; view state is
                                                  activated
*/
private  String _onviewactivated = null;

/*
* The attributes provide a possibility to assign
                                                  JavaScript on view state activation
*/
private  String _onviewactivation = null;

/*
* The attribute opens the list once edit
                                                  activated. Default value is
                                                  "true".
*/
private  boolean _openOnEdit = true;

private  boolean _openOnEditSet = false;

/*
* Defines custom save icon
*/
private  String _saveControlIcon = null;

/*
* The attribute make the input field select when
                                                  switched to edit state. Default value is
                                                  "true".
*/
private  boolean _selectOnEdit = true;

private  boolean _selectOnEditSet = false;

/*
* Sets width of the select element
*/
private  String _selectWidth = null;

/*
* The attribute serves to display
                                                  "save" and
                                                  "cancel" controls. Default value
                                                  is "false".
*/
private  boolean _showControls = false;

private  boolean _showControlsSet = false;

/*
* If "true", shows the SelectItem labels in the InplaceSelect pull-down list, but displays the value in the field in view mode once an item is selected.
        						          Default value is "false"
*/
private  boolean _showValueInView = false;

private  boolean _showValueInViewSet = false;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* The attribute serves to define the tabbing
                                                  order
*/
private  int _tabindex = Integer.MIN_VALUE;

private  boolean _tabindexSet = false;

/*
* Style class for view state
*/
private  String _viewClass = null;

/*
* CSS style class for hovered text in view
                                        state
*/
private  String _viewHoverClass = null;


public HtmlInplaceSelect(){
setRendererType("org.richfaces.renderkit.InplaceSelectRenderer");
}

public String getCancelControlIcon(){
	if (this._cancelControlIcon != null) {
		return this._cancelControlIcon;
	}
	ValueExpression ve = getValueExpression("cancelControlIcon");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCancelControlIcon(String _cancelControlIcon){
this._cancelControlIcon = _cancelControlIcon;
}

public String getChangedClass(){
	if (this._changedClass != null) {
		return this._changedClass;
	}
	ValueExpression ve = getValueExpression("changedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setChangedClass(String _changedClass){
this._changedClass = _changedClass;
}

public String getControlClass(){
	if (this._controlClass != null) {
		return this._controlClass;
	}
	ValueExpression ve = getValueExpression("controlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setControlClass(String _controlClass){
this._controlClass = _controlClass;
}

public String getControlHoverClass(){
	if (this._controlHoverClass != null) {
		return this._controlHoverClass;
	}
	ValueExpression ve = getValueExpression("controlHoverClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setControlHoverClass(String _controlHoverClass){
this._controlHoverClass = _controlHoverClass;
}

public String getControlPressClass(){
	if (this._controlPressClass != null) {
		return this._controlPressClass;
	}
	ValueExpression ve = getValueExpression("controlPressClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setControlPressClass(String _controlPressClass){
this._controlPressClass = _controlPressClass;
}

public String getControlsHorizontalPosition(){
	if (this._controlsHorizontalPosition != null) {
		return this._controlsHorizontalPosition;
	}
	ValueExpression ve = getValueExpression("controlsHorizontalPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "right";
	

}

public void setControlsHorizontalPosition(String _controlsHorizontalPosition){
this._controlsHorizontalPosition = _controlsHorizontalPosition;
}

public String getControlsVerticalPosition(){
	if (this._controlsVerticalPosition != null) {
		return this._controlsVerticalPosition;
	}
	ValueExpression ve = getValueExpression("controlsVerticalPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "center";
	

}

public void setControlsVerticalPosition(String _controlsVerticalPosition){
this._controlsVerticalPosition = _controlsVerticalPosition;
}

public String getDefaultLabel(){
	if (this._defaultLabel != null) {
		return this._defaultLabel;
	}
	ValueExpression ve = getValueExpression("defaultLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDefaultLabel(String _defaultLabel){
this._defaultLabel = _defaultLabel;
}

public String getEditClass(){
	if (this._editClass != null) {
		return this._editClass;
	}
	ValueExpression ve = getValueExpression("editClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEditClass(String _editClass){
this._editClass = _editClass;
}

public String getEditEvent(){
	if (this._editEvent != null) {
		return this._editEvent;
	}
	ValueExpression ve = getValueExpression("editEvent");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onclick";
	

}

public void setEditEvent(String _editEvent){
this._editEvent = _editEvent;
}

public boolean isEditOnTab(){
	if (this._editOnTabSet) {
	    return (this._editOnTab);
	}
	ValueExpression ve = getValueExpression("editOnTab");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._editOnTab);
	    }
	    
	    return value;
	} else {
	    return (this._editOnTab);
	}

}

public void setEditOnTab(boolean _editOnTab){
this._editOnTab = _editOnTab;
this._editOnTabSet = true;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabel(String _label){
this._label = _label;
}

public String getLayout(){
	if (this._layout != null) {
		return this._layout;
	}
	ValueExpression ve = getValueExpression("layout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "inline";
	

}

public void setLayout(String _layout){
this._layout = _layout;
}

public String getListHeight(){
	if (this._listHeight != null) {
		return this._listHeight;
	}
	ValueExpression ve = getValueExpression("listHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200px";
	

}

public void setListHeight(String _listHeight){
this._listHeight = _listHeight;
}

public String getListWidth(){
	if (this._listWidth != null) {
		return this._listWidth;
	}
	ValueExpression ve = getValueExpression("listWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200px";
	

}

public void setListWidth(String _listWidth){
this._listWidth = _listWidth;
}

public String getMaxSelectWidth(){
	if (this._maxSelectWidth != null) {
		return this._maxSelectWidth;
	}
	ValueExpression ve = getValueExpression("maxSelectWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200px";
	

}

public void setMaxSelectWidth(String _maxSelectWidth){
this._maxSelectWidth = _maxSelectWidth;
}

public String getMinSelectWidth(){
	if (this._minSelectWidth != null) {
		return this._minSelectWidth;
	}
	ValueExpression ve = getValueExpression("minSelectWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "100px";
	

}

public void setMinSelectWidth(String _minSelectWidth){
this._minSelectWidth = _minSelectWidth;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOneditactivated(){
	if (this._oneditactivated != null) {
		return this._oneditactivated;
	}
	ValueExpression ve = getValueExpression("oneditactivated");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOneditactivated(String _oneditactivated){
this._oneditactivated = _oneditactivated;
}

public String getOneditactivation(){
	if (this._oneditactivation != null) {
		return this._oneditactivation;
	}
	ValueExpression ve = getValueExpression("oneditactivation");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOneditactivation(String _oneditactivation){
this._oneditactivation = _oneditactivation;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOninputblur(){
	if (this._oninputblur != null) {
		return this._oninputblur;
	}
	ValueExpression ve = getValueExpression("oninputblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputblur(String _oninputblur){
this._oninputblur = _oninputblur;
}

public String getOninputclick(){
	if (this._oninputclick != null) {
		return this._oninputclick;
	}
	ValueExpression ve = getValueExpression("oninputclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputclick(String _oninputclick){
this._oninputclick = _oninputclick;
}

public String getOninputdblclick(){
	if (this._oninputdblclick != null) {
		return this._oninputdblclick;
	}
	ValueExpression ve = getValueExpression("oninputdblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputdblclick(String _oninputdblclick){
this._oninputdblclick = _oninputdblclick;
}

public String getOninputfocus(){
	if (this._oninputfocus != null) {
		return this._oninputfocus;
	}
	ValueExpression ve = getValueExpression("oninputfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputfocus(String _oninputfocus){
this._oninputfocus = _oninputfocus;
}

public String getOninputkeydown(){
	if (this._oninputkeydown != null) {
		return this._oninputkeydown;
	}
	ValueExpression ve = getValueExpression("oninputkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeydown(String _oninputkeydown){
this._oninputkeydown = _oninputkeydown;
}

public String getOninputkeypress(){
	if (this._oninputkeypress != null) {
		return this._oninputkeypress;
	}
	ValueExpression ve = getValueExpression("oninputkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeypress(String _oninputkeypress){
this._oninputkeypress = _oninputkeypress;
}

public String getOninputkeyup(){
	if (this._oninputkeyup != null) {
		return this._oninputkeyup;
	}
	ValueExpression ve = getValueExpression("oninputkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeyup(String _oninputkeyup){
this._oninputkeyup = _oninputkeyup;
}

public String getOninputmousedown(){
	if (this._oninputmousedown != null) {
		return this._oninputmousedown;
	}
	ValueExpression ve = getValueExpression("oninputmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmousedown(String _oninputmousedown){
this._oninputmousedown = _oninputmousedown;
}

public String getOninputmousemove(){
	if (this._oninputmousemove != null) {
		return this._oninputmousemove;
	}
	ValueExpression ve = getValueExpression("oninputmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmousemove(String _oninputmousemove){
this._oninputmousemove = _oninputmousemove;
}

public String getOninputmouseout(){
	if (this._oninputmouseout != null) {
		return this._oninputmouseout;
	}
	ValueExpression ve = getValueExpression("oninputmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseout(String _oninputmouseout){
this._oninputmouseout = _oninputmouseout;
}

public String getOninputmouseover(){
	if (this._oninputmouseover != null) {
		return this._oninputmouseover;
	}
	ValueExpression ve = getValueExpression("oninputmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseover(String _oninputmouseover){
this._oninputmouseover = _oninputmouseover;
}

public String getOninputmouseup(){
	if (this._oninputmouseup != null) {
		return this._oninputmouseup;
	}
	ValueExpression ve = getValueExpression("oninputmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseup(String _oninputmouseup){
this._oninputmouseup = _oninputmouseup;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnviewactivated(){
	if (this._onviewactivated != null) {
		return this._onviewactivated;
	}
	ValueExpression ve = getValueExpression("onviewactivated");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnviewactivated(String _onviewactivated){
this._onviewactivated = _onviewactivated;
}

public String getOnviewactivation(){
	if (this._onviewactivation != null) {
		return this._onviewactivation;
	}
	ValueExpression ve = getValueExpression("onviewactivation");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnviewactivation(String _onviewactivation){
this._onviewactivation = _onviewactivation;
}

public boolean isOpenOnEdit(){
	if (this._openOnEditSet) {
	    return (this._openOnEdit);
	}
	ValueExpression ve = getValueExpression("openOnEdit");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._openOnEdit);
	    }
	    
	    return value;
	} else {
	    return (this._openOnEdit);
	}

}

public void setOpenOnEdit(boolean _openOnEdit){
this._openOnEdit = _openOnEdit;
this._openOnEditSet = true;
}

public String getSaveControlIcon(){
	if (this._saveControlIcon != null) {
		return this._saveControlIcon;
	}
	ValueExpression ve = getValueExpression("saveControlIcon");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSaveControlIcon(String _saveControlIcon){
this._saveControlIcon = _saveControlIcon;
}

public boolean isSelectOnEdit(){
	if (this._selectOnEditSet) {
	    return (this._selectOnEdit);
	}
	ValueExpression ve = getValueExpression("selectOnEdit");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._selectOnEdit);
	    }
	    
	    return value;
	} else {
	    return (this._selectOnEdit);
	}

}

public void setSelectOnEdit(boolean _selectOnEdit){
this._selectOnEdit = _selectOnEdit;
this._selectOnEditSet = true;
}

public String getSelectWidth(){
	if (this._selectWidth != null) {
		return this._selectWidth;
	}
	ValueExpression ve = getValueExpression("selectWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelectWidth(String _selectWidth){
this._selectWidth = _selectWidth;
}

public boolean isShowControls(){
	if (this._showControlsSet) {
	    return (this._showControls);
	}
	ValueExpression ve = getValueExpression("showControls");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showControls);
	    }
	    
	    return value;
	} else {
	    return (this._showControls);
	}

}

public void setShowControls(boolean _showControls){
this._showControls = _showControls;
this._showControlsSet = true;
}

public boolean isShowValueInView(){
	if (this._showValueInViewSet) {
	    return (this._showValueInView);
	}
	ValueExpression ve = getValueExpression("showValueInView");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showValueInView);
	    }
	    
	    return value;
	} else {
	    return (this._showValueInView);
	}

}

public void setShowValueInView(boolean _showValueInView){
this._showValueInView = _showValueInView;
this._showValueInViewSet = true;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public int getTabindex(){
	if (this._tabindexSet) {
	    return (this._tabindex);
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._tabindex);
	    }
	    
	    return value;
	} else {
	    return (this._tabindex);
	}

}

public void setTabindex(int _tabindex){
this._tabindex = _tabindex;
this._tabindexSet = true;
}

public String getViewClass(){
	if (this._viewClass != null) {
		return this._viewClass;
	}
	ValueExpression ve = getValueExpression("viewClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setViewClass(String _viewClass){
this._viewClass = _viewClass;
}

public String getViewHoverClass(){
	if (this._viewHoverClass != null) {
		return this._viewHoverClass;
	}
	ValueExpression ve = getValueExpression("viewHoverClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setViewHoverClass(String _viewHoverClass){
this._viewHoverClass = _viewHoverClass;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[64];
state[0] = super.saveState(context);
state[1] = _cancelControlIcon;
state[2] = _changedClass;
state[3] = _controlClass;
state[4] = _controlHoverClass;
state[5] = _controlPressClass;
state[6] = _controlsHorizontalPosition;
state[7] = _controlsVerticalPosition;
state[8] = _defaultLabel;
state[9] = _editClass;
state[10] = _editEvent;
state[11] = Boolean.valueOf(_editOnTab);
state[12] = Boolean.valueOf(_editOnTabSet);
state[13] = _label;
state[14] = _layout;
state[15] = _listHeight;
state[16] = _listWidth;
state[17] = _maxSelectWidth;
state[18] = _minSelectWidth;
state[19] = _onblur;
state[20] = _onchange;
state[21] = _onclick;
state[22] = _ondblclick;
state[23] = _oneditactivated;
state[24] = _oneditactivation;
state[25] = _onfocus;
state[26] = _oninputblur;
state[27] = _oninputclick;
state[28] = _oninputdblclick;
state[29] = _oninputfocus;
state[30] = _oninputkeydown;
state[31] = _oninputkeypress;
state[32] = _oninputkeyup;
state[33] = _oninputmousedown;
state[34] = _oninputmousemove;
state[35] = _oninputmouseout;
state[36] = _oninputmouseover;
state[37] = _oninputmouseup;
state[38] = _onkeydown;
state[39] = _onkeypress;
state[40] = _onkeyup;
state[41] = _onmousedown;
state[42] = _onmousemove;
state[43] = _onmouseout;
state[44] = _onmouseover;
state[45] = _onmouseup;
state[46] = _onselect;
state[47] = _onviewactivated;
state[48] = _onviewactivation;
state[49] = Boolean.valueOf(_openOnEdit);
state[50] = Boolean.valueOf(_openOnEditSet);
state[51] = _saveControlIcon;
state[52] = Boolean.valueOf(_selectOnEdit);
state[53] = Boolean.valueOf(_selectOnEditSet);
state[54] = _selectWidth;
state[55] = Boolean.valueOf(_showControls);
state[56] = Boolean.valueOf(_showControlsSet);
state[57] = Boolean.valueOf(_showValueInView);
state[58] = Boolean.valueOf(_showValueInViewSet);
state[59] = _styleClass;
state[60] = Integer.valueOf(_tabindex);
state[61] = Boolean.valueOf(_tabindexSet);
state[62] = _viewClass;
state[63] = _viewHoverClass;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_cancelControlIcon = (String)states[1];;
		_changedClass = (String)states[2];;
		_controlClass = (String)states[3];;
		_controlHoverClass = (String)states[4];;
		_controlPressClass = (String)states[5];;
		_controlsHorizontalPosition = (String)states[6];;
		_controlsVerticalPosition = (String)states[7];;
		_defaultLabel = (String)states[8];;
		_editClass = (String)states[9];;
		_editEvent = (String)states[10];;
		_editOnTab = ((Boolean)states[11]).booleanValue();
		_editOnTabSet = ((Boolean)states[12]).booleanValue();
		_label = (String)states[13];;
		_layout = (String)states[14];;
		_listHeight = (String)states[15];;
		_listWidth = (String)states[16];;
		_maxSelectWidth = (String)states[17];;
		_minSelectWidth = (String)states[18];;
		_onblur = (String)states[19];;
		_onchange = (String)states[20];;
		_onclick = (String)states[21];;
		_ondblclick = (String)states[22];;
		_oneditactivated = (String)states[23];;
		_oneditactivation = (String)states[24];;
		_onfocus = (String)states[25];;
		_oninputblur = (String)states[26];;
		_oninputclick = (String)states[27];;
		_oninputdblclick = (String)states[28];;
		_oninputfocus = (String)states[29];;
		_oninputkeydown = (String)states[30];;
		_oninputkeypress = (String)states[31];;
		_oninputkeyup = (String)states[32];;
		_oninputmousedown = (String)states[33];;
		_oninputmousemove = (String)states[34];;
		_oninputmouseout = (String)states[35];;
		_oninputmouseover = (String)states[36];;
		_oninputmouseup = (String)states[37];;
		_onkeydown = (String)states[38];;
		_onkeypress = (String)states[39];;
		_onkeyup = (String)states[40];;
		_onmousedown = (String)states[41];;
		_onmousemove = (String)states[42];;
		_onmouseout = (String)states[43];;
		_onmouseover = (String)states[44];;
		_onmouseup = (String)states[45];;
		_onselect = (String)states[46];;
		_onviewactivated = (String)states[47];;
		_onviewactivation = (String)states[48];;
		_openOnEdit = ((Boolean)states[49]).booleanValue();
		_openOnEditSet = ((Boolean)states[50]).booleanValue();
		_saveControlIcon = (String)states[51];;
		_selectOnEdit = ((Boolean)states[52]).booleanValue();
		_selectOnEditSet = ((Boolean)states[53]).booleanValue();
		_selectWidth = (String)states[54];;
		_showControls = ((Boolean)states[55]).booleanValue();
		_showControlsSet = ((Boolean)states[56]).booleanValue();
		_showValueInView = ((Boolean)states[57]).booleanValue();
		_showValueInViewSet = ((Boolean)states[58]).booleanValue();
		_styleClass = (String)states[59];;
		_tabindex = ((Integer)states[60]).intValue();
		_tabindexSet = ((Boolean)states[61]).booleanValue();
		_viewClass = (String)states[62];;
		_viewHoverClass = (String)states[63];;
	
}

}
