/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp.tidy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.ajax4jsf.Messages;
import org.ajax4jsf.org.w3c.tidy.Tidy;
import org.ajax4jsf.org.w3c.tidy.TidyMessage;
import org.ajax4jsf.org.w3c.tidy.TidyMessageListener;
import org.ajax4jsf.webapp.HtmlParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TidyParser
implements TidyMessageListener,
HtmlParser {
    private static final Log log = LogFactory.getLog(TidyParser.class);
    private Tidy tidy = new Tidy();
    private String _viewState;
    private String _encoding;
    private String _outputEncoding;
    private Node[] headEvents;
    private static final String[] _htmlTypes = new String[]{"text/html"};
    private static final String[] _xmlTypes = new String[]{"text/xml"};
    private static final String[] _xhtmlTypes = new String[]{"application/xhtml+xml"};
    private static final String TIDY_MARK = "[TIDY_MESSAGE]";

    public TidyParser(Properties props) {
        this.tidy.setConfigurationFromProps(props);
        PrintWriter errout = new PrintWriter(new ErrorWriter());
        this.tidy.setErrout(errout);
        this.tidy.setForceOutput(true);
        this.tidy.setHideEndTags(false);
        this.tidy.setMessageListener(this);
    }

    private Node importNode(Document document, Node node, boolean recursive) {
        switch (node.getNodeType()) {
            case 1: {
                NodeList childNodes;
                Element element = document.createElement(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    int length = attributes.getLength();
                    for (int i = 0; i < length; ++i) {
                        element.setAttributeNode((Attr)this.importNode(document, attributes.item(i), recursive));
                    }
                }
                if (recursive && (childNodes = node.getChildNodes()) != null) {
                    int length = childNodes.getLength();
                    for (int i = 0; i < length; ++i) {
                        element.appendChild(this.importNode(document, childNodes.item(i), recursive));
                    }
                }
                return element;
            }
            case 2: {
                Attr attr = document.createAttribute(node.getNodeName());
                attr.setNodeValue(node.getNodeValue());
                return attr;
            }
            case 3: {
                String charData = ((CharacterData)node).getData();
                return document.createTextNode(charData);
            }
            case 4: {
                String charData = ((CharacterData)node).getData();
                return document.createCDATASection(charData);
            }
            case 8: {
                String charData = ((CharacterData)node).getData();
                return document.createComment(charData);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getNodeType());
    }

    public Document parseHtmlByTidy(Object input, Writer output) throws IOException {
        Document document = this.tidy.parseDOM(input, null);
        if (null != document) {
            Element documentElement = document.getDocumentElement();
            if (null != documentElement) {
                NodeVisitor nodeVisitor = new NodeVisitor();
                nodeVisitor.traverse(documentElement);
                List viewStateSpans = nodeVisitor.viewStateSpans;
                for (Node node : viewStateSpans) {
                    Node parentNode = node.getParentNode();
                    if (null != this._viewState) {
                        parentNode.replaceChild(document.createCDATASection(this._viewState), node);
                        continue;
                    }
                    if (node.hasChildNodes()) {
                        int j;
                        Node nextSibling = node.getNextSibling();
                        NodeList childNodes = node.getChildNodes();
                        Node[] childArray = new Node[childNodes.getLength()];
                        for (j = 0; j < childArray.length; ++j) {
                            childArray[j] = childNodes.item(j);
                        }
                        for (j = 0; j < childArray.length; ++j) {
                            parentNode.insertBefore(childArray[j], nextSibling);
                        }
                    }
                    parentNode.removeChild(node);
                }
                if (null != this.headEvents && this.headEvents.length > 0 || null != this._viewState) {
                    String nodeName;
                    Node child;
                    Node head = nodeVisitor.head;
                    if (null == head) {
                        head = document.createElement("head");
                        documentElement.insertBefore(head, documentElement.getFirstChild());
                    }
                    for (child = head.getFirstChild(); child != null && (!(child instanceof Element) || "title".equalsIgnoreCase(nodeName = ((Element)child).getNodeName()) || "base".equalsIgnoreCase(nodeName)); child = child.getNextSibling()) {
                    }
                    if (this.headEvents != null) {
                        for (Node node : this.headEvents) {
                            head.insertBefore(this.importNode(document, node, true), child);
                        }
                    }
                }
            }
            if (null != output) {
                this.tidy.pprint(document, output);
            }
        }
        return document;
    }

    public void parseHtml(InputStream input, Writer output) throws IOException {
        this.parseHtmlByTidy(input, output);
    }

    public void parseHtml(Reader input, Writer output) throws IOException {
        this.parseHtmlByTidy(input, output);
    }

    public void messageReceived(TidyMessage message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"MESSAGE_PARSING_INFO", (Object)message.getMessage()));
        }
    }

    public void setInputEncoding(String encoding) {
        if (null != encoding) {
            this._encoding = encoding;
            if (null != encoding) {
                this.tidy.setInputEncoding(encoding);
            }
        }
    }

    public void setOutputEncoding(String encoding) {
        if (null != encoding) {
            this._outputEncoding = encoding;
            if (null != encoding) {
                this.tidy.setOutputEncoding(encoding);
            }
        }
    }

    public boolean setMime(String mimeType) {
        if (null != mimeType) {
            String mime;
            int i;
            for (i = 0; i < _htmlTypes.length; ++i) {
                mime = _htmlTypes[i];
                if (!mimeType.startsWith(mime)) continue;
                this.tidy.setXHTML(false);
                this.tidy.setXmlOut(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Print output as ordinary HTML");
                }
                return true;
            }
            for (i = 0; i < _xhtmlTypes.length; ++i) {
                mime = _xhtmlTypes[i];
                if (!mimeType.startsWith(mime)) continue;
                this.tidy.setXHTML(true);
                this.tidy.setXmlOut(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Print output as XHTML");
                }
                return true;
            }
            for (i = 0; i < _xmlTypes.length; ++i) {
                mime = _xmlTypes[i];
                if (!mimeType.startsWith(mime)) continue;
                this.tidy.setXHTML(true);
                this.tidy.setXmlOut(true);
                this.tidy.setXmlPi(true);
                this.tidy.setEscapeCdata(false);
                this.tidy.setNumEntities(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Print output as XML");
                }
                return true;
            }
        }
        return false;
    }

    public void setMoveElements(boolean move) {
        this.tidy.setMoveElements(move);
    }

    public void setDoctype(String doctype) {
        this.tidy.setDocType("omit");
    }

    public void setViewState(String viewState) {
        this._viewState = viewState;
    }

    public void setHeadNodes(Node[] headEvents) {
        this.headEvents = headEvents;
    }

    private static class ErrorWriter
    extends Writer {
        private ErrorWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private static final class NodeVisitor {
        private List<Node> viewStateSpans = new ArrayList<Node>();
        private Node head = null;

        private NodeVisitor() {
        }

        private boolean isViewState(Element element) {
            return "org.ajax4jsf.view.state".equals(element.getAttribute("id")) && "org.ajax4jsf.view.state".equals(element.getAttribute("name"));
        }

        private void traverse(Node node) {
            String nodeName = node.getNodeName();
            if (this.head == null && "head".equals(nodeName)) {
                this.head = node;
            } else if ("span".equals(nodeName) && this.isViewState((Element)node)) {
                this.viewStateSpans.add(node);
            } else {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.traverse(child);
                }
            }
        }
    }
}

