import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

/**
 * @author Andrey Markavtsov
 * 
 */
public class Main {

	private static final Logger logger = Logger.getLogger(Main.class.getName());

	private static File HOME = null;

	private static File DESTINATION = null;

	private static final String testFolder = "\\src\\test\\java";

	private static final String generatedTestFolder = "\\generated-component\\test";

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
		if (args != null && args.length > 0 && "copy".equals(args[0]) ) {
			initPaths();
			copyAll(DESTINATION);
		}else {
			initPaths();
			deleteDirectory(DESTINATION);
		}
		
	}

	private static void initPaths() {
		String userDir = System.getProperty("user.dir");
		DESTINATION = new File(userDir + testFolder);
		HOME = new File(userDir + "\\..");
		logger.info("Home project: " + HOME.getAbsolutePath());
		logger.info("Destination folder: " + DESTINATION.getAbsolutePath());
	}

	private static void copyAll(File dest) throws IOException {
		File[] projects = HOME.listFiles();

		for (File project : projects) {
			if (!project.isFile() && !project.getName().startsWith(".")) {
				logger.info("Copy tests from [" + project.getName()
						+ "] project");
				String testClassesPath = project.getAbsolutePath() + testFolder;
				String generatedTestPath = project.getAbsolutePath()
						+ generatedTestFolder;
				File folderToCopy1 = new File(testClassesPath);
				File folderToCopy2 = new File(generatedTestPath);
				if (folderToCopy1.exists()) {
					copyDirectory(folderToCopy1, dest);
				}
				if (folderToCopy2.exists()) {
					copyDirectory(folderToCopy2, dest);
				}

			}

		}
	}

	private static void copyDirectory(File srcDir, File dstDir)
			throws IOException {
		if (".svn".equals(srcDir.getName())) {
			return;
		}
		if (srcDir.isDirectory()) {
			if (!dstDir.exists()) {
				dstDir.mkdir();
			}

			String[] children = srcDir.list();
			for (int i = 0; i < children.length; i++) {
				copyDirectory(new File(srcDir, children[i]), new File(dstDir,
						children[i]));
			}
		} else {
			CopyFile.copyFile(srcDir, dstDir);
		}
	}

	private static void deleteDirectory(File dir) throws IOException {
		if (dir.isDirectory()) {
			if (dir.exists()) {
				File [] children = dir.listFiles();
				for (int i = 0; i < children.length; i++) {
					deleteDirectory(children[i]);
				}
			}

		} else {
			if (dir.exists()) {
				System.out.println(dir.delete());
			}
		}
		dir.delete();
	}

}
