/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

public class TransformationStage<R extends ConnectRecord<R>>
implements AutoCloseable {
    static final String PREDICATE_CONFIG = "predicate";
    static final String NEGATE_CONFIG = "negate";
    private final Predicate<R> predicate;
    private final Transformation<R> transformation;
    private final boolean negate;

    TransformationStage(Transformation<R> transformation) {
        this(null, false, transformation);
    }

    TransformationStage(Predicate<R> predicate, boolean negate, Transformation<R> transformation) {
        this.predicate = predicate;
        this.negate = negate;
        this.transformation = transformation;
    }

    public Class<? extends Transformation<R>> transformClass() {
        Class transformClass = this.transformation.getClass();
        return transformClass;
    }

    public R apply(R record) {
        if (this.predicate == null || this.negate ^ this.predicate.test(record)) {
            return (R)this.transformation.apply(record);
        }
        return record;
    }

    public Transformation<R> transformation() {
        return this.transformation;
    }

    @Override
    public void close() {
        Utils.closeQuietly(this.transformation, (String)"transformation");
        Utils.closeQuietly(this.predicate, (String)PREDICATE_CONFIG);
    }

    public String toString() {
        return "TransformationStage{predicate=" + String.valueOf(this.predicate) + ", transformation=" + String.valueOf(this.transformation) + ", negate=" + this.negate + "}";
    }
}

