/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.HerderRequest;
import org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.events.EmitterFactory;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.InternalRequestSignature;
import org.apache.kafka.connect.runtime.rest.entities.ActiveTopicsInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorOffsets;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.LoggerLevel;
import org.apache.kafka.connect.runtime.rest.entities.Message;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.maven.artifact.versioning.VersionRange;

public interface Herder {
    public void start();

    public void stop();

    public boolean isReady();

    public void healthCheck(Callback<Void> var1);

    public void connectors(Callback<Collection<String>> var1);

    public void connectorInfo(String var1, Callback<ConnectorInfo> var2);

    public void connectorConfig(String var1, Callback<Map<String, String>> var2);

    public void putConnectorConfig(String var1, Map<String, String> var2, boolean var3, Callback<Created<ConnectorInfo>> var4);

    default public void putConnectorConfig(String connName, Map<String, String> config, boolean allowReplace, Callback<Created<ConnectorInfo>> callback, boolean validated) {
        this.putConnectorConfig(connName, config, allowReplace, callback);
    }

    public void putConnectorConfig(String var1, Map<String, String> var2, TargetState var3, boolean var4, Callback<Created<ConnectorInfo>> var5);

    public void patchConnectorConfig(String var1, Map<String, String> var2, Callback<Created<ConnectorInfo>> var3);

    public void deleteConnectorConfig(String var1, Callback<Created<ConnectorInfo>> var2);

    public void requestTaskReconfiguration(String var1);

    public void taskConfigs(String var1, Callback<List<TaskInfo>> var2);

    public void putTaskConfigs(String var1, List<Map<String, String>> var2, Callback<Void> var3, InternalRequestSignature var4);

    public void fenceZombieSourceTasks(String var1, Callback<Void> var2, InternalRequestSignature var3);

    public void triggerRebalance(boolean var1, Callback<Void> var2);

    public Collection<String> connectors();

    public ConnectorInfo connectorInfo(String var1);

    default public ConnectorInfo getProcessedConnectorInfo(String connName) {
        return this.connectorInfo(connName);
    }

    public ConnectorStateInfo connectorStatus(String var1);

    public ActiveTopicsInfo connectorActiveTopics(String var1);

    public void resetConnectorActiveTopics(String var1);

    public StatusBackingStore statusBackingStore();

    public ConnectorStateInfo.TaskState taskStatus(ConnectorTaskId var1);

    public void validateConnectorConfig(Map<String, String> var1, Callback<ConfigInfos> var2);

    default public void validateConnectorConfig(Map<String, String> connectorConfig, Callback<ConfigInfos> callback, boolean doLog, boolean skipConnectorValidations) {
        this.validateConnectorConfig(connectorConfig, callback);
    }

    public void restartTask(ConnectorTaskId var1, Callback<Void> var2);

    public void restartConnector(String var1, Callback<Void> var2);

    public HerderRequest restartConnector(long var1, String var3, Callback<Void> var4);

    public void restartConnectorAndTasks(RestartRequest var1, Callback<ConnectorStateInfo> var2);

    public void stopConnector(String var1, Callback<Void> var2);

    public void pauseConnector(String var1);

    public void resumeConnector(String var1);

    public Plugins plugins();

    public String kafkaClusterId();

    public List<ConfigKeyInfo> connectorPluginConfig(String var1);

    public List<ConfigKeyInfo> connectorPluginConfig(String var1, VersionRange var2);

    public void connectorOffsets(String var1, Callback<ConnectorOffsets> var2);

    public void alterConnectorOffsets(String var1, Map<Map<String, ?>, Map<String, ?>> var2, Callback<Message> var3);

    public void resetConnectorOffsets(String var1, Callback<Message> var2);

    public LoggerLevel loggerLevel(String var1);

    public Map<String, LoggerLevel> allLoggerLevels();

    public Map<String, Map<String, String>> allLoggerLevelsWithTimeouts();

    public List<String> setWorkerLoggerLevel(String var1, String var2);

    public Map<String, Long> setWorkerLoggerLevelWithTimeout(String var1, String var2, Long var3);

    public void setClusterLoggerLevel(String var1, String var2);

    @Confluent
    public void setupEventEmitter(EmitterFactory var1);

    public ConnectMetrics connectMetrics();

    public record Created<T>(boolean created, T result) {
    }

    public static enum ConfigReloadAction {
        NONE,
        RESTART;

    }
}

