/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.LoggerContext;
import org.apache.kafka.connect.runtime.rest.entities.LoggerLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Loggers {
    private static final Logger log = LoggerFactory.getLogger(Loggers.class);
    private static final String ROOT_LOGGER_NAME = "root";
    private static final List<String> VALID_ROOT_LOGGER_NAMES = List.of("", "root");
    final Time time;

    public static Loggers newInstance(Time time) {
        Objects.requireNonNull(time);
        try {
            return new Log4jLoggers(time);
        }
        catch (ClassCastException | LinkageError e) {
            log.info("No supported logging implementation found. Logging configuration endpoint will be disabled.");
            return new NoOpLoggers(time);
        }
        catch (Exception e) {
            log.warn("A problem occurred, while initializing the logging controller. Logging configuration endpoint will be disabled.", (Throwable)e);
            return new NoOpLoggers(time);
        }
    }

    private Loggers(Time time) {
        this.time = time;
    }

    public abstract LoggerLevel level(String var1);

    public abstract Map<String, LoggerLevel> allLevels();

    public abstract Map<String, Map<String, String>> allLevelsWithTimeouts();

    public abstract List<String> setLevel(String var1, String var2);

    public abstract Map<String, Long> setLevelWithTimeout(String var1, String var2, Long var3);

    public abstract boolean isValidLevel(String var1);

    static class Log4jLoggers
    extends Loggers {
        final org.apache.logging.log4j.core.LoggerContext loggerContext;
        final Map<String, LoggerContext> loggerContextMap;
        private static final String SHUTDOWN_HOOK_LOG_AUTORESET_SERVICE = "shutdownLogAutoResetService";
        private static final String LOG_AUTO_RESET_SERVICE_THREAD_PATTERN = "LogAutoResetService-%d";
        private ScheduledExecutorService logAutoResetService = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"LogAutoResetService-%d", (boolean)false));

        Log4jLoggers(Time time) {
            super(time);
            this.loggerContextMap = new ConcurrentHashMap<String, LoggerContext>();
            Exit.addShutdownHook((String)SHUTDOWN_HOOK_LOG_AUTORESET_SERVICE, () -> this.logAutoResetService.shutdownNow());
            this.loggerContext = (org.apache.logging.log4j.core.LoggerContext)LogManager.getContext((boolean)false);
        }

        @Override
        public LoggerLevel level(String logger) {
            Objects.requireNonNull(logger, "Logger may not be null");
            org.apache.logging.log4j.Logger foundLogger = null;
            if (this.isValidRootLoggerName(logger)) {
                foundLogger = this.rootLogger();
            } else {
                Collection<org.apache.logging.log4j.core.Logger> currentLoggers = this.currentLoggers().values();
                for (org.apache.logging.log4j.Logger logger2 : currentLoggers) {
                    if (!logger.equals(logger2.getName())) continue;
                    foundLogger = logger2;
                    break;
                }
            }
            if (foundLogger == null) {
                log.warn("Unable to find level for logger {}", (Object)logger);
                return null;
            }
            return this.loggerLevel(foundLogger);
        }

        @Override
        public Map<String, LoggerLevel> allLevels() {
            return this.currentLoggers().values().stream().filter(logger -> !logger.getLevel().equals((Object)Level.OFF)).collect(Collectors.toMap(this::getLoggerName, this::loggerLevel, (existing, replacing) -> replacing, TreeMap::new));
        }

        @Override
        public Map<String, Map<String, String>> allLevelsWithTimeouts() {
            TreeMap<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
            Collection<org.apache.logging.log4j.core.Logger> enumeration = this.currentLoggers().values();
            enumeration.stream().filter(logger -> !logger.getLevel().equals((Object)Level.OFF)).forEach(logger -> result.put(logger.getName(), this.levelAndTimeoutToMap((org.apache.logging.log4j.Logger)logger)));
            org.apache.logging.log4j.Logger root = this.rootLogger();
            if (!root.getLevel().equals((Object)Level.OFF)) {
                result.put(Loggers.ROOT_LOGGER_NAME, Collections.singletonMap("level", String.valueOf(root.getLevel())));
            }
            return result;
        }

        @Override
        public List<String> setLevel(String namespace, String level) {
            Objects.requireNonNull(namespace, "Logging namespace may not be null");
            Objects.requireNonNull(level, "Level may not be null");
            String internalNameSpace = this.isValidRootLoggerName(namespace) ? "" : namespace;
            log.info("Setting level of namespace {} and children to {}", (Object)internalNameSpace, (Object)level);
            Collection<org.apache.logging.log4j.core.Logger> loggers = this.loggers(internalNameSpace);
            Map<String, LoggerLevel> nameToLevel = this.allLevels();
            ArrayList<String> result = new ArrayList<String>();
            Configurator.setAllLevels((String)internalNameSpace, (Level)Level.valueOf((String)level));
            for (org.apache.logging.log4j.Logger logger : loggers) {
                LoggerContext logContext;
                String oldLevel;
                String name = this.getLoggerName(logger);
                String newLevel = logger.getLevel().name();
                if (newLevel.equalsIgnoreCase(oldLevel = nameToLevel.getOrDefault(name, new LoggerLevel("", this.time.milliseconds())).level())) continue;
                if (this.loggerContextMap.containsKey(name) && (logContext = this.loggerContextMap.get(name)).getLoggerContextAutoReset() != null) {
                    logContext.getLoggerContextAutoReset().getAutoResetFuture().cancel(false);
                    logContext.setLoggerContextAutoReset(null);
                }
                this.loggerContextMap.put(logger.getName(), new LoggerContext(this.time.milliseconds()));
                result.add(name);
            }
            Collections.sort(result);
            return result;
        }

        @Override
        public boolean isValidLevel(String level) {
            return !level.isEmpty() && Level.getLevel((String)level) != null;
        }

        @Override
        public Map<String, Long> setLevelWithTimeout(String namespace, String level, Long timeout) {
            Objects.requireNonNull(namespace, "Logging namespace may not be null");
            Objects.requireNonNull(level, "Level may not be null");
            Objects.requireNonNull(timeout, "Timeout may not be null");
            log.info("Setting level of namespace {} and children to {} with a timeout {} on this worker", new Object[]{namespace, level, timeout});
            Collection<org.apache.logging.log4j.core.Logger> childLoggers = this.loggers(namespace);
            TreeMap<String, Long> result = new TreeMap<String, Long>();
            for (org.apache.logging.log4j.Logger logger : childLoggers) {
                Optional<LoggerContext> loggerContextOptional = Optional.ofNullable(this.loggerContextMap.get(logger.getName()));
                Optional<LoggerContext.LoggerContextAutoReset> loggerContextAutoResetOptional = loggerContextOptional.map(LoggerContext::getLoggerContextAutoReset);
                Level oldLogLevel = loggerContextAutoResetOptional.map(LoggerContext.LoggerContextAutoReset::getLevel).orElse(logger.getLevel());
                result.put(logger.getName(), timeout);
                Configurator.setLevel((org.apache.logging.log4j.Logger)logger, (Level)Level.valueOf((String)level));
                ScheduledFuture<?> autoResetFuture = this.logAutoResetService.schedule(() -> {
                    Log4jLoggers log4jLoggers = this;
                    synchronized (log4jLoggers) {
                        Configurator.setLevel((org.apache.logging.log4j.Logger)logger, (Level)oldLogLevel);
                        LoggerContext loggerContext = this.loggerContextMap.get(logger.getName());
                        if (loggerContext != null) {
                            loggerContext.setLoggerContextAutoReset(null);
                        }
                    }
                }, (long)timeout, TimeUnit.MILLISECONDS);
                this.loggerContextMap.putIfAbsent(logger.getName(), new LoggerContext());
                this.loggerContextMap.get(logger.getName()).setLoggerContextAutoReset(new LoggerContext.LoggerContextAutoReset(oldLogLevel, timeout, autoResetFuture));
            }
            return result;
        }

        private Collection<org.apache.logging.log4j.core.Logger> loggers(String namespace) {
            Objects.requireNonNull(namespace, "Logging namespace may not be null");
            if (this.isValidRootLoggerName(namespace)) {
                return this.currentLoggers().values();
            }
            ArrayList<org.apache.logging.log4j.core.Logger> result = new ArrayList<org.apache.logging.log4j.core.Logger>();
            Map<String, org.apache.logging.log4j.core.Logger> nameToLogger = this.currentLoggers();
            org.apache.logging.log4j.core.Logger ancestorLogger = this.lookupLogger(namespace);
            Collection<org.apache.logging.log4j.core.Logger> currentLoggers = nameToLogger.values();
            boolean present = false;
            for (org.apache.logging.log4j.core.Logger currentLogger : currentLoggers) {
                if (currentLogger.getName().startsWith(namespace)) {
                    result.add(currentLogger);
                }
                if (!namespace.equals(currentLogger.getName())) continue;
                present = true;
            }
            if (!present) {
                result.add(ancestorLogger);
            }
            return result;
        }

        private Map<String, String> levelAndTimeoutToMap(org.apache.logging.log4j.Logger logger) {
            HashMap<String, String> levelAndTimeoutMap = new HashMap<String, String>();
            levelAndTimeoutMap.put("level", String.valueOf(logger.getLevel()));
            Optional<Long> timeoutOptional = Optional.ofNullable(this.loggerContextMap.get(logger.getName())).map(LoggerContext::getLoggerContextAutoReset).map(LoggerContext.LoggerContextAutoReset::getDelay);
            timeoutOptional.ifPresent(timeout -> levelAndTimeoutMap.put("timeout", String.valueOf(timeout)));
            return levelAndTimeoutMap;
        }

        org.apache.logging.log4j.core.Logger lookupLogger(String logger) {
            return this.loggerContext.getLogger(this.isValidRootLoggerName(logger) ? "" : logger);
        }

        Map<String, org.apache.logging.log4j.core.Logger> currentLoggers() {
            org.apache.logging.log4j.core.LoggerContext context = (org.apache.logging.log4j.core.LoggerContext)LogManager.getContext((boolean)false);
            HashMap<String, org.apache.logging.log4j.core.Logger> results = new HashMap<String, org.apache.logging.log4j.core.Logger>();
            context.getConfiguration().getLoggers().forEach((name, logger) -> results.put((String)name, this.loggerContext.getLogger(name)));
            context.getLoggerRegistry().getLoggers().forEach(logger -> results.put(logger.getName(), (org.apache.logging.log4j.core.Logger)logger));
            return results;
        }

        org.apache.logging.log4j.Logger rootLogger() {
            return LogManager.getRootLogger();
        }

        Map<String, LoggerContext> loggerContextMap() {
            return this.loggerContextMap;
        }

        void setLogAutoResetService(ScheduledExecutorService scheduledExecutorService) {
            this.logAutoResetService = scheduledExecutorService;
        }

        private boolean isValidRootLoggerName(String namespace) {
            return VALID_ROOT_LOGGER_NAMES.stream().anyMatch(rootLoggerNames -> rootLoggerNames.equalsIgnoreCase(namespace));
        }

        private String getLoggerName(String loggerName) {
            return loggerName.equals("") ? Loggers.ROOT_LOGGER_NAME : loggerName;
        }

        private String getLoggerName(org.apache.logging.log4j.Logger logger) {
            return this.getLoggerName(logger.getName());
        }

        private LoggerLevel loggerLevel(org.apache.logging.log4j.Logger logger) {
            Long lastModified = Optional.ofNullable(this.loggerContextMap.get(this.getLoggerName(logger))).map(LoggerContext::getLastModifiedTime).orElse(null);
            return new LoggerLevel(Objects.toString(logger.getLevel()), lastModified);
        }
    }

    private static class NoOpLoggers
    extends Loggers {
        private NoOpLoggers(Time time) {
            super(time);
        }

        @Override
        public LoggerLevel level(String loggerName) {
            return new LoggerLevel("OFF", 0L);
        }

        @Override
        public Map<String, LoggerLevel> allLevels() {
            return Map.of();
        }

        @Override
        public Map<String, Map<String, String>> allLevelsWithTimeouts() {
            return Map.of();
        }

        @Override
        public List<String> setLevel(String loggerName, String level) {
            return List.of();
        }

        @Override
        public Map<String, Long> setLevelWithTimeout(String namespace, String level, Long timeout) {
            return Map.of();
        }

        @Override
        public boolean isValidLevel(String level) {
            return "OFF".equals(level);
        }
    }
}

