/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

public class EventsException
extends Exception {
    public EventsException(String message) {
        super(message);
    }

    public EventsException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class UnableToPublishEventException
    extends EventsException {
        private static final String MESSAGE = "Unable to publish event";

        public UnableToPublishEventException(Throwable e) {
            super(MESSAGE, e);
        }

        public UnableToPublishEventException() {
            super(MESSAGE);
        }
    }

    public static class UnknownConnectorException
    extends EventsException {
        public UnknownConnectorException(String connectorName) {
            super("Unknown connector: " + connectorName);
        }
    }

    public static class FailedToDetermineLeaderException
    extends EventsException {
        public FailedToDetermineLeaderException(Throwable e) {
            super("Failed to determine if this worker is the cluster leader", e);
        }
    }
}

