/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.entities.LoggerLevel;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin/loggers")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LoggingResource {
    private static final Logger log = LoggerFactory.getLogger(LoggingResource.class);
    private static final String WORKER_SCOPE = "worker";
    private static final String CLUSTER_SCOPE = "cluster";
    private final Herder herder;

    @Inject
    public LoggingResource(Herder herder) {
        this.herder = herder;
    }

    @GET
    @Operation(summary="List the current loggers that have their levels explicitly set and their log levels")
    public Response listLoggers() {
        return Response.ok(this.herder.allLoggerLevels()).build();
    }

    @GET
    @Path(value="/{logger}")
    @Operation(summary="Get the log level for the specified logger")
    public Response getLogger(@PathParam(value="logger") String namedLogger) {
        Objects.requireNonNull(namedLogger, "require non-null name");
        LoggerLevel loggerLevel = this.herder.loggerLevel(namedLogger);
        if (loggerLevel == null) {
            throw new NotFoundException("Logger " + namedLogger + " not found.");
        }
        return Response.ok((Object)loggerLevel).build();
    }

    @PUT
    @Path(value="/{logger}")
    @Operation(summary="Set the log level for the specified logger")
    public Response setLevel(@PathParam(value="logger") String namespace, Map<String, String> levelMap, @DefaultValue(value="worker") @QueryParam(value="scope") @Parameter(description="The scope for the logging modification (single-worker, cluster-wide, etc.)") String scope) {
        String levelString;
        if (scope == null) {
            log.warn("Received null scope in request to adjust logging level; will default to {}", (Object)WORKER_SCOPE);
            scope = WORKER_SCOPE;
        }
        if ((levelString = levelMap.get("level")) == null) {
            throw new BadRequestException("Desired 'level' parameter was not specified in request.");
        }
        if (Level.getLevel((String)levelString) == null) {
            throw new NotFoundException("invalid log level '" + levelString + "'.");
        }
        switch (scope.toLowerCase(Locale.ROOT)) {
            default: {
                log.warn("Received invalid scope '{}' in request to adjust logging level; will default to {}", (Object)scope, (Object)WORKER_SCOPE);
            }
            case "worker": {
                List<String> affectedLoggers = this.herder.setWorkerLoggerLevel(namespace, levelString);
                return Response.ok(affectedLoggers).build();
            }
            case "cluster": 
        }
        this.herder.setClusterLoggerLevel(namespace, levelString);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/{logger}/timeout")
    @Operation(summary="Set the level for the specified logger with specified timeout")
    public Response setLevelWithTimeout(@PathParam(value="logger") String namespace, Map<String, String> levelTimeoutMap) {
        Long timeout;
        String levelString = levelTimeoutMap.get("level");
        if (levelString == null) {
            throw new BadRequestException("Desired 'level' parameter was not specified in request.");
        }
        try {
            timeout = Long.parseLong(levelTimeoutMap.get("timeout"));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(e.getMessage());
        }
        if (Level.getLevel((String)levelString) == null) {
            throw new NotFoundException("invalid log level '" + levelString + "'.");
        }
        Map<String, Long> affectedLoggers = this.herder.setWorkerLoggerLevelWithTimeout(namespace, levelString, timeout);
        return Response.ok(affectedLoggers).build();
    }

    @GET
    @Path(value="/timeouts")
    @Operation(summary="List the current loggers that have their levels explicitly set and their log levels, auto-reset timeouts")
    public Response listLoggersWithTimeouts() {
        return Response.ok(this.herder.allLoggerLevelsWithTimeouts()).build();
    }
}

