/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class MirrorTopicRecord
implements ApiMessage {
    Uuid topicId;
    String topicName;
    Uuid clusterLinkId;
    String clusterLinkName;
    String sourceTopicName;
    Uuid sourceTopicId;
    String mirrorTopicState;
    long timeMs;
    List<Long> mirrorStartOffsets;
    String previousToPausedState;
    List<Long> stoppedLogEndOffsets;
    boolean promoted;
    boolean topicLevelPause;
    boolean linkLevelPause;
    short mirrorTopicError;
    String nextState;
    List<Integer> stoppedEpochs;
    List<Long> truncationOffsets;
    List<Integer> truncationEpochs;
    long stoppedSequenceNumber;
    MirrorTopicSwitchoverMetadata lastSwitchoverMetadata;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public MirrorTopicRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public MirrorTopicRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public MirrorTopicRecord() {
        this.topicId = Uuid.ZERO_UUID;
        this.topicName = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.clusterLinkName = "";
        this.sourceTopicName = "";
        this.sourceTopicId = Uuid.ZERO_UUID;
        this.mirrorTopicState = "";
        this.timeMs = 0L;
        this.mirrorStartOffsets = null;
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
        this.promoted = false;
        this.topicLevelPause = false;
        this.linkLevelPause = false;
        this.mirrorTopicError = (short)-1;
        this.nextState = null;
        this.stoppedEpochs = null;
        this.truncationOffsets = null;
        this.truncationEpochs = null;
        this.stoppedSequenceNumber = 0L;
        this.lastSwitchoverMetadata = null;
    }

    public short apiKey() {
        return 10001;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.topicId = _readable.readUuid();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field topicName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field topicName had invalid length " + length);
        }
        this.topicName = _readable.readString(length);
        this.clusterLinkId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clusterLinkName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clusterLinkName had invalid length " + length);
        }
        this.clusterLinkName = _context.read(EntityType.LINK_NAME, _readable.readString(length));
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field sourceTopicName was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field sourceTopicName had invalid length " + length);
        }
        this.sourceTopicName = _readable.readString(length);
        this.sourceTopicId = _readable.readUuid();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field mirrorTopicState was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field mirrorTopicState had invalid length " + length);
        }
        this.mirrorTopicState = _readable.readString(length);
        this.timeMs = _readable.readLong();
        this.mirrorStartOffsets = null;
        this.previousToPausedState = null;
        this.stoppedLogEndOffsets = null;
        this.promoted = false;
        this.topicLevelPause = false;
        this.linkLevelPause = false;
        this.mirrorTopicError = (short)-1;
        this.nextState = null;
        this.stoppedEpochs = null;
        this.truncationOffsets = null;
        this.truncationEpochs = null;
        this.stoppedSequenceNumber = 0L;
        this.lastSwitchoverMetadata = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block15: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 5: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.mirrorStartOffsets = null;
                        continue block15;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.mirrorStartOffsets = newCollection;
                    continue block15;
                }
                case 0: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.previousToPausedState = null;
                        continue block15;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field previousToPausedState had invalid length " + length2);
                    }
                    this.previousToPausedState = _readable.readString(length2);
                    continue block15;
                }
                case 1: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.stoppedLogEndOffsets = null;
                        continue block15;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.stoppedLogEndOffsets = newCollection;
                    continue block15;
                }
                case 2: {
                    this.promoted = _readable.readByte() != 0;
                    continue block15;
                }
                case 3: {
                    this.topicLevelPause = _readable.readByte() != 0;
                    continue block15;
                }
                case 4: {
                    this.linkLevelPause = _readable.readByte() != 0;
                    continue block15;
                }
                case 6: {
                    this.mirrorTopicError = _readable.readShort();
                    continue block15;
                }
                case 7: {
                    int length2 = _readable.readUnsignedVarint() - 1;
                    if (length2 < 0) {
                        this.nextState = null;
                        continue block15;
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field nextState had invalid length " + length2);
                    }
                    this.nextState = _readable.readString(length2);
                    continue block15;
                }
                case 8: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.stoppedEpochs = null;
                        continue block15;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((Long)_readable.readInt());
                    }
                    this.stoppedEpochs = newCollection;
                    continue block15;
                }
                case 9: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.truncationOffsets = null;
                        continue block15;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readLong());
                    }
                    this.truncationOffsets = newCollection;
                    continue block15;
                }
                case 10: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.truncationEpochs = null;
                        continue block15;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Long> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((Long)_readable.readInt());
                    }
                    this.truncationEpochs = newCollection;
                    continue block15;
                }
                case 11: {
                    this.stoppedSequenceNumber = _readable.readLong();
                    continue block15;
                }
                case 12: {
                    if (_readable.readUnsignedVarint() <= 0) {
                        this.lastSwitchoverMetadata = null;
                        continue block15;
                    }
                    this.lastSwitchoverMetadata = new MirrorTopicSwitchoverMetadata(_readable, _version, _context);
                    continue block15;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeUuid(this.topicId);
        byte[] _stringBytes2 = _cache.getSerializedValue((Object)this.topicName);
        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
        _writable.writeByteArray(_stringBytes2);
        _writable.writeUuid(this.clusterLinkId);
        _stringBytes2 = _cache.getSerializedValue((Object)this.clusterLinkName);
        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
        _writable.writeByteArray(_stringBytes2);
        _stringBytes2 = _cache.getSerializedValue((Object)this.sourceTopicName);
        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
        _writable.writeByteArray(_stringBytes2);
        _writable.writeUuid(this.sourceTopicId);
        _stringBytes2 = _cache.getSerializedValue((Object)this.mirrorTopicState);
        _writable.writeUnsignedVarint(_stringBytes2.length + 1);
        _writable.writeByteArray(_stringBytes2);
        _writable.writeLong(this.timeMs);
        if (this.mirrorStartOffsets != null) {
            ++_numTaggedFields;
        }
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
        }
        if (this.promoted) {
            ++_numTaggedFields;
        }
        if (this.topicLevelPause) {
            ++_numTaggedFields;
        }
        if (this.linkLevelPause) {
            ++_numTaggedFields;
        }
        if (this.mirrorTopicError != -1) {
            ++_numTaggedFields;
        }
        if (this.nextState != null) {
            ++_numTaggedFields;
        }
        if (this.stoppedEpochs != null) {
            ++_numTaggedFields;
        }
        if (this.truncationOffsets != null) {
            ++_numTaggedFields;
        }
        if (this.truncationEpochs != null) {
            ++_numTaggedFields;
        }
        if (this.stoppedSequenceNumber != 0L) {
            ++_numTaggedFields;
        }
        if (this.lastSwitchoverMetadata != null) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.previousToPausedState != null) {
            _writable.writeUnsignedVarint(0);
            _stringBytes = _cache.getSerializedValue((Object)this.previousToPausedState);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.stoppedLogEndOffsets != null) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.stoppedLogEndOffsets).intValue());
            _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
            _stringBytes = this.stoppedLogEndOffsets.iterator();
            while (_stringBytes.hasNext()) {
                Long stoppedLogEndOffsetsElement = (Long)_stringBytes.next();
                _writable.writeLong(stoppedLogEndOffsetsElement.longValue());
            }
        }
        if (this.promoted) {
            _writable.writeUnsignedVarint(2);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.promoted ? (byte)1 : 0);
        }
        if (this.topicLevelPause) {
            _writable.writeUnsignedVarint(3);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.topicLevelPause ? (byte)1 : 0);
        }
        if (this.linkLevelPause) {
            _writable.writeUnsignedVarint(4);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.linkLevelPause ? (byte)1 : 0);
        }
        if (this.mirrorStartOffsets != null) {
            _writable.writeUnsignedVarint(5);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.mirrorStartOffsets).intValue());
            _writable.writeUnsignedVarint(this.mirrorStartOffsets.size() + 1);
            _stringBytes = this.mirrorStartOffsets.iterator();
            while (_stringBytes.hasNext()) {
                Long mirrorStartOffsetsElement = (Long)_stringBytes.next();
                _writable.writeLong(mirrorStartOffsetsElement.longValue());
            }
        }
        if (this.mirrorTopicError != -1) {
            _writable.writeUnsignedVarint(6);
            _writable.writeUnsignedVarint(2);
            _writable.writeShort(this.mirrorTopicError);
        }
        if (this.nextState != null) {
            _writable.writeUnsignedVarint(7);
            _stringBytes = _cache.getSerializedValue((Object)this.nextState);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
            _writable.writeUnsignedVarint(((Object)_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.stoppedEpochs != null) {
            _writable.writeUnsignedVarint(8);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.stoppedEpochs).intValue());
            _writable.writeUnsignedVarint(this.stoppedEpochs.size() + 1);
            for (Integer stoppedEpochsElement : this.stoppedEpochs) {
                _writable.writeInt(stoppedEpochsElement.intValue());
            }
        }
        if (this.truncationOffsets != null) {
            _writable.writeUnsignedVarint(9);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.truncationOffsets).intValue());
            _writable.writeUnsignedVarint(this.truncationOffsets.size() + 1);
            for (Long truncationOffsetsElement : this.truncationOffsets) {
                _writable.writeLong(truncationOffsetsElement.longValue());
            }
        }
        if (this.truncationEpochs != null) {
            _writable.writeUnsignedVarint(10);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.truncationEpochs).intValue());
            _writable.writeUnsignedVarint(this.truncationEpochs.size() + 1);
            for (Integer truncationEpochsElement : this.truncationEpochs) {
                _writable.writeInt(truncationEpochsElement.intValue());
            }
        }
        if (this.stoppedSequenceNumber != 0L) {
            _writable.writeUnsignedVarint(11);
            _writable.writeUnsignedVarint(8);
            _writable.writeLong(this.stoppedSequenceNumber);
        }
        if (this.lastSwitchoverMetadata != null) {
            _writable.writeUnsignedVarint(12);
            _writable.writeUnsignedVarint(this.lastSwitchoverMetadata.size(_cache, _version, _context) + 1);
            _writable.writeUnsignedVarint(1);
            this.lastSwitchoverMetadata.write(_writable, _cache, _version, _context);
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _stringPrefixSize;
        int _arraySize;
        int _numTaggedFields = 0;
        _size.addBytes(16);
        byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'topicName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.topicName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        _stringBytes = _context.write(EntityType.LINK_NAME, this.clusterLinkName).getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clusterLinkName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clusterLinkName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.sourceTopicName.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'sourceTopicName' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.sourceTopicName, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(16);
        _stringBytes = this.mirrorTopicState.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'mirrorTopicState' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.mirrorTopicState, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(8);
        if (this.mirrorStartOffsets != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.mirrorStartOffsets.size() + 1)));
            _size.addBytes(this.mirrorStartOffsets.size() * 8);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.mirrorStartOffsets, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.previousToPausedState != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.previousToPausedState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'previousToPausedState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.previousToPausedState, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (this.stoppedLogEndOffsets != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.stoppedLogEndOffsets.size() + 1)));
            _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.stoppedLogEndOffsets, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.promoted) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this.topicLevelPause) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this.linkLevelPause) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this.mirrorTopicError != -1) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(2);
        }
        if (this.nextState != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.nextState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'nextState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.nextState, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)(_stringPrefixSize + _stringBytes.length)));
        }
        if (this.stoppedEpochs != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.stoppedEpochs.size() + 1)));
            _size.addBytes(this.stoppedEpochs.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.stoppedEpochs, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.truncationOffsets != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.truncationOffsets.size() + 1)));
            _size.addBytes(this.truncationOffsets.size() * 8);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.truncationOffsets, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.truncationEpochs != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.truncationEpochs.size() + 1)));
            _size.addBytes(this.truncationEpochs.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.truncationEpochs, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.stoppedSequenceNumber != 0L) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        if (this.lastSwitchoverMetadata != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeStruct = _size.totalSize();
            _size.addBytes(1);
            this.lastSwitchoverMetadata.addSize(_size, _cache, _version, _context);
            int _structSize = _size.totalSize() - _sizeBeforeStruct;
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_structSize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MirrorTopicRecord)) {
            return false;
        }
        MirrorTopicRecord other = (MirrorTopicRecord)obj;
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.clusterLinkName == null ? other.clusterLinkName != null : !this.clusterLinkName.equals(other.clusterLinkName)) {
            return false;
        }
        if (this.sourceTopicName == null ? other.sourceTopicName != null : !this.sourceTopicName.equals(other.sourceTopicName)) {
            return false;
        }
        if (!this.sourceTopicId.equals((Object)other.sourceTopicId)) {
            return false;
        }
        if (this.mirrorTopicState == null ? other.mirrorTopicState != null : !this.mirrorTopicState.equals(other.mirrorTopicState)) {
            return false;
        }
        if (this.timeMs != other.timeMs) {
            return false;
        }
        if (this.mirrorStartOffsets == null ? other.mirrorStartOffsets != null : !this.mirrorStartOffsets.equals(other.mirrorStartOffsets)) {
            return false;
        }
        if (this.previousToPausedState == null ? other.previousToPausedState != null : !this.previousToPausedState.equals(other.previousToPausedState)) {
            return false;
        }
        if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
            return false;
        }
        if (this.promoted != other.promoted) {
            return false;
        }
        if (this.topicLevelPause != other.topicLevelPause) {
            return false;
        }
        if (this.linkLevelPause != other.linkLevelPause) {
            return false;
        }
        if (this.mirrorTopicError != other.mirrorTopicError) {
            return false;
        }
        if (this.nextState == null ? other.nextState != null : !this.nextState.equals(other.nextState)) {
            return false;
        }
        if (this.stoppedEpochs == null ? other.stoppedEpochs != null : !this.stoppedEpochs.equals(other.stoppedEpochs)) {
            return false;
        }
        if (this.truncationOffsets == null ? other.truncationOffsets != null : !this.truncationOffsets.equals(other.truncationOffsets)) {
            return false;
        }
        if (this.truncationEpochs == null ? other.truncationEpochs != null : !this.truncationEpochs.equals(other.truncationEpochs)) {
            return false;
        }
        if (this.stoppedSequenceNumber != other.stoppedSequenceNumber) {
            return false;
        }
        if (this.lastSwitchoverMetadata == null ? other.lastSwitchoverMetadata != null : !this.lastSwitchoverMetadata.equals(other.lastSwitchoverMetadata)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.clusterLinkName == null ? 0 : this.clusterLinkName.hashCode());
        hashCode = 31 * hashCode + (this.sourceTopicName == null ? 0 : this.sourceTopicName.hashCode());
        hashCode = 31 * hashCode + this.sourceTopicId.hashCode();
        hashCode = 31 * hashCode + (this.mirrorTopicState == null ? 0 : this.mirrorTopicState.hashCode());
        hashCode = 31 * hashCode + ((int)(this.timeMs >> 32) ^ (int)this.timeMs);
        hashCode = 31 * hashCode + (this.mirrorStartOffsets == null ? 0 : this.mirrorStartOffsets.hashCode());
        hashCode = 31 * hashCode + (this.previousToPausedState == null ? 0 : this.previousToPausedState.hashCode());
        hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
        hashCode = 31 * hashCode + (this.promoted ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.topicLevelPause ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.linkLevelPause ? 1231 : 1237);
        hashCode = 31 * hashCode + this.mirrorTopicError;
        hashCode = 31 * hashCode + (this.nextState == null ? 0 : this.nextState.hashCode());
        hashCode = 31 * hashCode + (this.stoppedEpochs == null ? 0 : this.stoppedEpochs.hashCode());
        hashCode = 31 * hashCode + (this.truncationOffsets == null ? 0 : this.truncationOffsets.hashCode());
        hashCode = 31 * hashCode + (this.truncationEpochs == null ? 0 : this.truncationEpochs.hashCode());
        hashCode = 31 * hashCode + ((int)(this.stoppedSequenceNumber >> 32) ^ (int)this.stoppedSequenceNumber);
        hashCode = 31 * hashCode + (this.lastSwitchoverMetadata == null ? 0 : this.lastSwitchoverMetadata.hashCode());
        return hashCode;
    }

    public MirrorTopicRecord duplicate() {
        MirrorTopicRecord _duplicate = new MirrorTopicRecord();
        _duplicate.topicId = this.topicId;
        _duplicate.topicName = this.topicName;
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.clusterLinkName = this.clusterLinkName;
        _duplicate.sourceTopicName = this.sourceTopicName;
        _duplicate.sourceTopicId = this.sourceTopicId;
        _duplicate.mirrorTopicState = this.mirrorTopicState;
        _duplicate.timeMs = this.timeMs;
        if (this.mirrorStartOffsets == null) {
            _duplicate.mirrorStartOffsets = null;
        } else {
            ArrayList<Long> newMirrorStartOffsets = new ArrayList<Long>(this.mirrorStartOffsets.size());
            for (Long l : this.mirrorStartOffsets) {
                newMirrorStartOffsets.add(l);
            }
            _duplicate.mirrorStartOffsets = newMirrorStartOffsets;
        }
        _duplicate.previousToPausedState = this.previousToPausedState == null ? null : this.previousToPausedState;
        if (this.stoppedLogEndOffsets == null) {
            _duplicate.stoppedLogEndOffsets = null;
        } else {
            ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
            for (Long l : this.stoppedLogEndOffsets) {
                newStoppedLogEndOffsets.add(l);
            }
            _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
        }
        _duplicate.promoted = this.promoted;
        _duplicate.topicLevelPause = this.topicLevelPause;
        _duplicate.linkLevelPause = this.linkLevelPause;
        _duplicate.mirrorTopicError = this.mirrorTopicError;
        _duplicate.nextState = this.nextState == null ? null : this.nextState;
        if (this.stoppedEpochs == null) {
            _duplicate.stoppedEpochs = null;
        } else {
            ArrayList<Integer> newStoppedEpochs = new ArrayList<Integer>(this.stoppedEpochs.size());
            for (Integer n : this.stoppedEpochs) {
                newStoppedEpochs.add(n);
            }
            _duplicate.stoppedEpochs = newStoppedEpochs;
        }
        if (this.truncationOffsets == null) {
            _duplicate.truncationOffsets = null;
        } else {
            ArrayList<Long> newTruncationOffsets = new ArrayList<Long>(this.truncationOffsets.size());
            for (Long l : this.truncationOffsets) {
                newTruncationOffsets.add(l);
            }
            _duplicate.truncationOffsets = newTruncationOffsets;
        }
        if (this.truncationEpochs == null) {
            _duplicate.truncationEpochs = null;
        } else {
            ArrayList<Integer> newTruncationEpochs = new ArrayList<Integer>(this.truncationEpochs.size());
            for (Integer n : this.truncationEpochs) {
                newTruncationEpochs.add(n);
            }
            _duplicate.truncationEpochs = newTruncationEpochs;
        }
        _duplicate.stoppedSequenceNumber = this.stoppedSequenceNumber;
        _duplicate.lastSwitchoverMetadata = this.lastSwitchoverMetadata == null ? null : this.lastSwitchoverMetadata.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "MirrorTopicRecord(topicId=" + this.topicId.toString() + ", topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ", clusterLinkName=" + (String)(this.clusterLinkName == null ? "null" : "'" + this.clusterLinkName.toString() + "'") + ", sourceTopicName=" + (String)(this.sourceTopicName == null ? "null" : "'" + this.sourceTopicName.toString() + "'") + ", sourceTopicId=" + this.sourceTopicId.toString() + ", mirrorTopicState=" + (String)(this.mirrorTopicState == null ? "null" : "'" + this.mirrorTopicState.toString() + "'") + ", timeMs=" + this.timeMs + ", mirrorStartOffsets=" + (this.mirrorStartOffsets == null ? "null" : MessageUtil.deepToString(this.mirrorStartOffsets.iterator())) + ", previousToPausedState=" + (String)(this.previousToPausedState == null ? "null" : "'" + this.previousToPausedState.toString() + "'") + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ", promoted=" + (this.promoted ? "true" : "false") + ", topicLevelPause=" + (this.topicLevelPause ? "true" : "false") + ", linkLevelPause=" + (this.linkLevelPause ? "true" : "false") + ", mirrorTopicError=" + this.mirrorTopicError + ", nextState=" + (String)(this.nextState == null ? "null" : "'" + this.nextState.toString() + "'") + ", stoppedEpochs=" + (this.stoppedEpochs == null ? "null" : MessageUtil.deepToString(this.stoppedEpochs.iterator())) + ", truncationOffsets=" + (this.truncationOffsets == null ? "null" : MessageUtil.deepToString(this.truncationOffsets.iterator())) + ", truncationEpochs=" + (this.truncationEpochs == null ? "null" : MessageUtil.deepToString(this.truncationEpochs.iterator())) + ", stoppedSequenceNumber=" + this.stoppedSequenceNumber + ", lastSwitchoverMetadata=" + (this.lastSwitchoverMetadata == null ? "null" : this.lastSwitchoverMetadata.toString()) + ")";
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topicName() {
        return this.topicName;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String clusterLinkName() {
        return this.clusterLinkName;
    }

    public String sourceTopicName() {
        return this.sourceTopicName;
    }

    public Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public String mirrorTopicState() {
        return this.mirrorTopicState;
    }

    public long timeMs() {
        return this.timeMs;
    }

    public List<Long> mirrorStartOffsets() {
        return this.mirrorStartOffsets;
    }

    public String previousToPausedState() {
        return this.previousToPausedState;
    }

    public List<Long> stoppedLogEndOffsets() {
        return this.stoppedLogEndOffsets;
    }

    public boolean promoted() {
        return this.promoted;
    }

    public boolean topicLevelPause() {
        return this.topicLevelPause;
    }

    public boolean linkLevelPause() {
        return this.linkLevelPause;
    }

    public short mirrorTopicError() {
        return this.mirrorTopicError;
    }

    public String nextState() {
        return this.nextState;
    }

    public List<Integer> stoppedEpochs() {
        return this.stoppedEpochs;
    }

    public List<Long> truncationOffsets() {
        return this.truncationOffsets;
    }

    public List<Integer> truncationEpochs() {
        return this.truncationEpochs;
    }

    public long stoppedSequenceNumber() {
        return this.stoppedSequenceNumber;
    }

    public MirrorTopicSwitchoverMetadata lastSwitchoverMetadata() {
        return this.lastSwitchoverMetadata;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MirrorTopicRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public MirrorTopicRecord setTopicName(String v) {
        this.topicName = v;
        return this;
    }

    public MirrorTopicRecord setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public MirrorTopicRecord setClusterLinkName(String v) {
        this.clusterLinkName = v;
        return this;
    }

    public MirrorTopicRecord setSourceTopicName(String v) {
        this.sourceTopicName = v;
        return this;
    }

    public MirrorTopicRecord setSourceTopicId(Uuid v) {
        this.sourceTopicId = v;
        return this;
    }

    public MirrorTopicRecord setMirrorTopicState(String v) {
        this.mirrorTopicState = v;
        return this;
    }

    public MirrorTopicRecord setTimeMs(long v) {
        this.timeMs = v;
        return this;
    }

    public MirrorTopicRecord setMirrorStartOffsets(List<Long> v) {
        this.mirrorStartOffsets = v;
        return this;
    }

    public MirrorTopicRecord setPreviousToPausedState(String v) {
        this.previousToPausedState = v;
        return this;
    }

    public MirrorTopicRecord setStoppedLogEndOffsets(List<Long> v) {
        this.stoppedLogEndOffsets = v;
        return this;
    }

    public MirrorTopicRecord setPromoted(boolean v) {
        this.promoted = v;
        return this;
    }

    public MirrorTopicRecord setTopicLevelPause(boolean v) {
        this.topicLevelPause = v;
        return this;
    }

    public MirrorTopicRecord setLinkLevelPause(boolean v) {
        this.linkLevelPause = v;
        return this;
    }

    public MirrorTopicRecord setMirrorTopicError(short v) {
        this.mirrorTopicError = v;
        return this;
    }

    public MirrorTopicRecord setNextState(String v) {
        this.nextState = v;
        return this;
    }

    public MirrorTopicRecord setStoppedEpochs(List<Integer> v) {
        this.stoppedEpochs = v;
        return this;
    }

    public MirrorTopicRecord setTruncationOffsets(List<Long> v) {
        this.truncationOffsets = v;
        return this;
    }

    public MirrorTopicRecord setTruncationEpochs(List<Integer> v) {
        this.truncationEpochs = v;
        return this;
    }

    public MirrorTopicRecord setStoppedSequenceNumber(long v) {
        this.stoppedSequenceNumber = v;
        return this;
    }

    public MirrorTopicRecord setLastSwitchoverMetadata(MirrorTopicSwitchoverMetadata v) {
        this.lastSwitchoverMetadata = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The unique ID of this mirror topic."), new Field("topic_name", (Type)Type.COMPACT_STRING, "The name of this mirror topic. For debugging purposes only."), new Field("cluster_link_id", (Type)Type.UUID, "The unique ID of this cluster link."), new Field("cluster_link_name", (Type)Type.COMPACT_STRING, "The name of this cluster link. For debugging purposes only."), new Field("source_topic_name", (Type)Type.COMPACT_STRING, "The name of the source topic for this mirror topic."), new Field("source_topic_id", (Type)Type.UUID, "The unique ID of the source topic for this mirror topic. Will be Uuid#ZERO_UUID if source topic does not support topic IDs."), new Field("mirror_topic_state", (Type)Type.COMPACT_STRING, "The state of the mirror topic."), new Field("time_ms", (Type)Type.INT64, "The epoch time at which the state change occurred."), Field.TaggedFieldsSection.of((Object[])new Object[]{5, new Field("mirror_start_offsets", (Type)CompactArrayOf.nullable((Type)Type.INT64), "List of earliest offsets to start mirroring from, ordered by partition. By default, mirroring starts from the first available offset."), 0, new Field("previous_to_paused_state", (Type)Type.COMPACT_NULLABLE_STRING, "The state this mirror topic will go into if unpaused. Null if mirror topic is not paused."), 1, new Field("stopped_log_end_offsets", (Type)CompactArrayOf.nullable((Type)Type.INT64), "List of log end offsets ordered by partition ids that the mirror topic was stopped at if mirror topic was state. Null if mirror topic is not stopped."), 2, new Field("promoted", (Type)Type.BOOLEAN, "Set to true if the mirror topic is promoted. This will be set to false when the mirror topic is failed over. This is only valid when the mirror topic state is PendingStopped."), 3, new Field("topic_level_pause", (Type)Type.BOOLEAN, "Set to true if the mirror topic is paused explicitly by user."), 4, new Field("link_level_pause", (Type)Type.BOOLEAN, "Set to true if the mirror topics are paused by pausing the cluster link."), 6, new Field("mirror_topic_error", (Type)Type.INT16, "Reason for mirror topic failure, if this mirror is in failed state."), 7, new Field("next_state", (Type)Type.COMPACT_NULLABLE_STRING, "The state the remote mirror topic will go into after synchronization. Null if mirror topic is not in PendingSynchronize state."), 8, new Field("stopped_epochs", (Type)CompactArrayOf.nullable((Type)Type.INT32), "List of destination partition leader epochs ordered by partition ids before the mirror topic was stopped, if mirror topic is in stopped state. Null if mirror topic is not stopped."), 9, new Field("truncation_offsets", (Type)CompactArrayOf.nullable((Type)Type.INT64), "List of log end offsets ordered by partition ids for the mirror topic in the PendingSetupForRestoreMirror state that we could truncate to. Null if mirror topic is not in a PendingSetupForRestoreMirror state."), 10, new Field("truncation_epochs", (Type)CompactArrayOf.nullable((Type)Type.INT32), "List of partition leader epochs for the mirror topic in the PendingSetupForRestoreMirror state used to determine truncation offsets. Null if mirror topic is not in a PendingSetupForRestoreMirror state."), 11, new Field("stopped_sequence_number", (Type)Type.INT64, "The stopped sequence number for this mirror topic. Only updated when converting topic to a stopped mirror topic."), 12, new Field("last_switchover_metadata", (Type)MirrorTopicSwitchoverMetadata.SCHEMA_0, "Topic-specific information about the last switchover operation.")})});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class MirrorTopicSwitchoverMetadata
    implements Message {
        short errorCode;
        String errorMessage;
        long messagesTruncated;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public MirrorTopicSwitchoverMetadata(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MirrorTopicSwitchoverMetadata() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.messagesTruncated = 0L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorTopicSwitchoverMetadata");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field errorMessage was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
            this.messagesTruncated = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeLong(this.messagesTruncated);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MirrorTopicSwitchoverMetadata");
            }
            _size.addBytes(2);
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MirrorTopicSwitchoverMetadata)) {
                return false;
            }
            MirrorTopicSwitchoverMetadata other = (MirrorTopicSwitchoverMetadata)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.messagesTruncated != other.messagesTruncated) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + ((int)(this.messagesTruncated >> 32) ^ (int)this.messagesTruncated);
            return hashCode;
        }

        public MirrorTopicSwitchoverMetadata duplicate() {
            MirrorTopicSwitchoverMetadata _duplicate = new MirrorTopicSwitchoverMetadata();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage;
            _duplicate.messagesTruncated = this.messagesTruncated;
            return _duplicate;
        }

        public String toString() {
            return "MirrorTopicSwitchoverMetadata(errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", messagesTruncated=" + this.messagesTruncated + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public long messagesTruncated() {
            return this.messagesTruncated;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MirrorTopicSwitchoverMetadata setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public MirrorTopicSwitchoverMetadata setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public MirrorTopicSwitchoverMetadata setMessagesTruncated(long v) {
            this.messagesTruncated = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "Topic-specific error code for the last switchover."), new Field("error_message", (Type)Type.COMPACT_STRING, "Topic-specific error message for the last switchover."), new Field("messages_truncated", (Type)Type.INT64, "Number of messages truncated from this topic in the last switchover."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

