/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamChangeRecord;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamEntryRecord;
import org.apache.kafka.common.metadata.ConfluentKeyValueStreamTopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.InternalTopicType;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.Logger;

public class ConfluentKeyValueStreamsControlManager {
    private final Logger log;

    public ConfluentKeyValueStreamsControlManager(LogContext logContext) {
        this.log = logContext.logger(ConfluentKeyValueStreamsControlManager.class);
    }

    ControllerResult<Void> updateConfluentKeyValueStreamChangeRecord(InternalTopicType recordType, String key, String value, short partitionId, long offset) {
        this.log.debug("Confluent Key Value Stream Change Record on topic {}, partition id {}, offset {}", new Object[]{recordType.name(), partitionId, offset});
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        ConfluentKeyValueStreamChangeRecord record = new ConfluentKeyValueStreamChangeRecord().setType(recordType.value()).setPartition(partitionId).setOffset(offset).setEntryKey(key).setEntryValue(value);
        records.add(new ApiMessageAndVersion((ApiMessage)record, 0));
        return new ControllerResult<Object>(records, null, false);
    }

    public void replay(ConfluentKeyValueStreamChangeRecord record) {
    }

    public void replay(ConfluentKeyValueStreamTopicRecord record) {
    }

    public void replay(ConfluentKeyValueStreamEntryRecord record) {
    }
}

