/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Objects;
import org.apache.kafka.common.metadata.ClusterLinkChangeRecord;
import org.apache.kafka.common.metadata.ClusterLinkRecord;

public class ClusterLinkSwitchoverMetadata {
    private final SwitchoverType switchoverType;
    private final long switchoverTimestamp;
    private final SwitchoverState switchoverState;
    private final short errorCode;
    private final String errorMessage;

    public ClusterLinkSwitchoverMetadata(SwitchoverType switchoverType, long switchoverTimestamp, SwitchoverState switchoverState, short errorCode, String errorMessage) {
        this.switchoverType = switchoverType;
        this.switchoverTimestamp = switchoverTimestamp;
        this.switchoverState = switchoverState;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ClusterLinkSwitchoverMetadata(ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord record) {
        this(SwitchoverType.fromValue(record.switchoverType()), record.switchoverTimestamp(), SwitchoverState.fromValue(record.switchoverState()), record.errorCode(), record.errorMessage());
    }

    public ClusterLinkSwitchoverMetadata(ClusterLinkChangeRecord.ClusterLinkSwitchoverMetadataRecord record) {
        this(SwitchoverType.fromValue(record.switchoverType()), record.switchoverTimestamp(), SwitchoverState.fromValue(record.switchoverState()), record.errorCode(), record.errorMessage());
    }

    public SwitchoverType switchoverType() {
        return this.switchoverType;
    }

    public long switchoverTimestamp() {
        return this.switchoverTimestamp;
    }

    public SwitchoverState switchoverState() {
        return this.switchoverState;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord toRecord() {
        return new ClusterLinkRecord.ClusterLinkSwitchoverMetadataRecord().setSwitchoverType(this.switchoverType.value()).setSwitchoverTimestamp(this.switchoverTimestamp).setSwitchoverState(this.switchoverState.value()).setErrorCode(this.errorCode).setErrorMessage(this.errorMessage);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterLinkSwitchoverMetadata)) {
            return false;
        }
        ClusterLinkSwitchoverMetadata other = (ClusterLinkSwitchoverMetadata)o;
        return this.switchoverType.equals((Object)other.switchoverType) && this.switchoverTimestamp == other.switchoverTimestamp && this.switchoverState.equals((Object)other.switchoverState) && this.errorCode == other.errorCode && this.errorMessage.equals(other.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.switchoverType, this.switchoverTimestamp, this.switchoverState, this.errorCode, this.errorMessage});
    }

    public String toString() {
        return "ClusterLinkSwitchoverMetadata(switchoverType=" + this.switchoverType.toString() + ", switchoverTimestamp=" + this.switchoverTimestamp + ", switchoverState=" + this.switchoverState.toString() + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ")";
    }

    public static enum SwitchoverType {
        FAILOVER(0),
        REVERSE(1),
        RESTORE(2);

        private final byte value;

        private SwitchoverType(byte b) {
            this.value = b;
        }

        public byte value() {
            return this.value;
        }

        public static SwitchoverType fromValue(byte b) {
            for (SwitchoverType type : SwitchoverType.values()) {
                if (type.value != b) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown SwitchoverType byte value: " + b);
        }
    }

    public static enum SwitchoverState {
        PRIMARY(0),
        SECONDARY(1),
        PENDING_PRIMARY(2),
        PENDING_SECONDARY(3),
        INACTIVE(4);

        private final byte value;

        private SwitchoverState(byte b) {
            this.value = b;
        }

        public byte value() {
            return this.value;
        }

        public static SwitchoverState fromValue(byte b) {
            for (SwitchoverState state : SwitchoverState.values()) {
                if (state.value != b) continue;
                return state;
            }
            throw new IllegalArgumentException("Unknown SwitchoverState byte value: " + b);
        }
    }
}

