/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.metadata.authorizer.StandardAcl;

public class ConfluentStandardAcl {
    private final StandardAcl standardAcl;
    private final Optional<Uuid> clusterLinkId;
    private final AclState aclState;

    public ConfluentStandardAcl(StandardAcl standardAcl, Optional<Uuid> clusterLinkId) {
        this(standardAcl, clusterLinkId, AclState.ACTIVE);
    }

    public ConfluentStandardAcl(StandardAcl standardAcl, Optional<Uuid> clusterLinkId, AclState aclState) {
        this.standardAcl = standardAcl;
        this.clusterLinkId = clusterLinkId;
        if (aclState == AclState.UNKNOWN || aclState == AclState.ANY) {
            throw new IllegalArgumentException("Invalid aclState : " + String.valueOf(aclState));
        }
        this.aclState = aclState;
    }

    public StandardAcl standardAcl() {
        return this.standardAcl;
    }

    public Optional<Uuid> clusterLinkId() {
        return this.clusterLinkId;
    }

    public AclState aclState() {
        return this.aclState;
    }

    public static List<ConfluentStandardAcl> fromAclBinding(AclBinding aclBinding) {
        return ConfluentStandardAcl.fromAclBindingWithAclState(aclBinding, AclState.ACTIVE);
    }

    public static List<ConfluentStandardAcl> fromAclBindingWithAclState(AclBinding aclBinding, AclState aclState) {
        StandardAcl standardAcl = ConfluentStandardAcl.standardAclFromAclBinding(aclBinding);
        if (aclBinding.entry().clusterLinkIds().isEmpty()) {
            return Collections.singletonList(new ConfluentStandardAcl(standardAcl, Optional.empty(), aclState));
        }
        ArrayList<ConfluentStandardAcl> aclList = new ArrayList<ConfluentStandardAcl>();
        for (Uuid linkId : aclBinding.entry().clusterLinkIds()) {
            if (!linkId.equals((Object)Uuid.ZERO_UUID)) {
                aclList.add(new ConfluentStandardAcl(standardAcl, Optional.of(linkId), aclState));
                continue;
            }
            aclList.add(new ConfluentStandardAcl(standardAcl, Optional.empty(), aclState));
        }
        return aclList;
    }

    private static StandardAcl standardAclFromAclBinding(AclBinding aclBinding) {
        return StandardAcl.fromAclBinding(aclBinding);
    }

    public AclBinding toBinding() {
        Set linkIds = this.clusterLinkId.map(Collections::singleton).orElse(Collections.emptySet());
        AccessControlEntry accessControlEntry = new AccessControlEntry(this.standardAcl.principal(), this.standardAcl.host(), this.standardAcl.operation(), this.standardAcl.permissionType(), linkIds);
        return new AclBinding(this.standardAcl.resourcePattern(), accessControlEntry);
    }

    public static ConfluentStandardAcl fromRecord(AccessControlEntryRecord record) {
        Optional<Uuid> linkId = record.clusterLinkId().equals((Object)Uuid.ZERO_UUID) ? Optional.empty() : Optional.of(record.clusterLinkId());
        AclState aclState = AclState.fromCode((byte)record.aclState());
        return new ConfluentStandardAcl(StandardAcl.fromRecord(record), linkId, aclState);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(ConfluentStandardAcl.class)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ConfluentStandardAcl other = (ConfluentStandardAcl)o;
        return Objects.equals(this.standardAcl, other.standardAcl) && Objects.equals(this.clusterLinkId, other.clusterLinkId) && Objects.equals(this.aclState, other.aclState);
    }

    public int hashCode() {
        return Objects.hash(this.standardAcl, this.clusterLinkId, this.aclState);
    }

    public String toString() {
        return "ConfluentStandardAcl(standardAcl=" + String.valueOf(this.standardAcl) + ", clusterLinkId=" + String.valueOf(this.clusterLinkId) + ", aclState=" + String.valueOf(this.aclState) + ")";
    }

    public ConfluentStandardAcl toLocalAcl() {
        if (this.clusterLinkId.equals(Uuid.ZERO_UUID)) {
            return this;
        }
        return new ConfluentStandardAcl(this.standardAcl, Optional.empty(), this.aclState);
    }

    public boolean hasLinkId() {
        return this.clusterLinkId.isPresent() && !this.clusterLinkId.get().equals((Object)Uuid.ZERO_UUID);
    }
}

