/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.config.ConfigMonitor;
import org.apache.kafka.metadata.config.ConfigMonitorKeyAndDefinition;
import org.slf4j.Logger;

public final class SpecificResourceConfigMonitor<T>
implements ConfigMonitor {
    private static final String DYNAMIC_DEFAULT = "dynamicDefault";
    private static final String DYNAMIC_VALUE = "dynamicValue";
    private final ConfigMonitorKeyAndDefinition keyAndDefinition;
    private final String targetResourceName;
    private final Map<String, T> values;
    private final T staticDefault;

    SpecificResourceConfigMonitor(ConfigMonitorKeyAndDefinition keyAndDefinition, String targetResourceName, Map<String, T> values, T staticDefault) {
        this.keyAndDefinition = keyAndDefinition;
        this.targetResourceName = targetResourceName;
        this.values = values;
        this.staticDefault = staticDefault;
    }

    @Override
    public ConfigMonitorKeyAndDefinition keyAndDefinition() {
        return this.keyAndDefinition;
    }

    T dynamicDefault() {
        return this.values.get(DYNAMIC_DEFAULT);
    }

    void setDynamicDefault(T newValue) {
        if (newValue == null) {
            this.values.remove(DYNAMIC_DEFAULT);
        } else {
            this.values.put(DYNAMIC_DEFAULT, newValue);
        }
    }

    T dynamicValue() {
        return this.values.get(DYNAMIC_VALUE);
    }

    void setDynamicValue(T newValue) {
        if (newValue == null) {
            this.values.remove(DYNAMIC_VALUE);
        } else {
            this.values.put(DYNAMIC_VALUE, newValue);
        }
    }

    @Override
    public void update(Logger log, String resourceName, String newValueString) {
        T prevEffectiveValue;
        String keyName = this.keyName();
        Object newValue = ConfigDef.parseType((String)keyName, (Object)newValueString, (ConfigDef.Type)this.definition().type);
        if (resourceName.isEmpty()) {
            if (Objects.equals(this.dynamicDefault(), newValue)) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping callback because default configuration {} for {} remains unchanged as '{}'", new Object[]{keyName, this.resourceType(), this.isSensitive() ? "[redacted]" : newValue});
                }
                return;
            }
            prevEffectiveValue = this.effectiveValue();
            this.setDynamicDefault(newValue);
        } else {
            if (!resourceName.equals(this.targetResourceName)) {
                if (log.isTraceEnabled()) {
                    log.trace("Ignoring change to configuration {} for {}.", (Object)keyName, (Object)new ConfigResource(this.resourceType(), resourceName));
                }
                return;
            }
            if (Objects.equals(this.dynamicValue(), newValue)) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping callback because configuration {} for {} remains unchanged as '{}'", new Object[]{keyName, new ConfigResource(this.resourceType(), resourceName), this.isSensitive() ? "[redacted]" : newValue});
                }
                return;
            }
            prevEffectiveValue = this.effectiveValue();
            this.setDynamicValue(newValue);
        }
        T newEffectiveValue = this.effectiveValue();
        if (!Objects.equals(prevEffectiveValue, newEffectiveValue)) {
            log.info("Set configuration for {} for {} to '{}'", new Object[]{keyName, this.resourceType(), this.isSensitive() ? "[redacted]" : newValue});
        } else if (log.isDebugEnabled()) {
            log.debug("Effective configuration for {} for {} remains unchanged as '{}'", new Object[]{keyName, this.resourceType(), this.isSensitive() ? "[redacted]" : newValue});
        }
    }

    public T effectiveValue() {
        T value = this.dynamicValue();
        if (value != null) {
            return value;
        }
        value = this.dynamicDefault();
        if (value != null) {
            return value;
        }
        return this.staticDefault;
    }
}

