/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class TraceContextRecord
implements ApiMessage {
    byte[] traceId;
    byte[] spanId;
    byte traceFlags;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("trace_id", (Type)Type.COMPACT_BYTES, "Opentelemetry trace id to identify the trace"), new Field("span_id", (Type)Type.COMPACT_BYTES, "Opentelemetry span id to identify the span"), new Field("trace_flags", (Type)Type.INT8, "Trace flags for spans. This has the same struct as the w3c trace flags"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public TraceContextRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public TraceContextRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public TraceContextRecord() {
        this.traceId = Bytes.EMPTY;
        this.spanId = Bytes.EMPTY;
        this.traceFlags = 0;
    }

    public short apiKey() {
        return 10020;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field traceId was serialized as null");
        }
        byte[] newBytes = _readable.readArray(length);
        this.traceId = newBytes;
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field spanId was serialized as null");
        }
        newBytes = _readable.readArray(length);
        this.spanId = newBytes;
        this.traceFlags = _readable.readByte();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.traceId.length + 1);
        _writable.writeByteArray(this.traceId);
        _writable.writeUnsignedVarint(this.spanId.length + 1);
        _writable.writeByteArray(this.spanId);
        _writable.writeByte(this.traceFlags);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(this.traceId.length);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.traceId.length + 1)));
        _size.addBytes(this.spanId.length);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.spanId.length + 1)));
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TraceContextRecord)) {
            return false;
        }
        TraceContextRecord other = (TraceContextRecord)obj;
        if (!Arrays.equals(this.traceId, other.traceId)) {
            return false;
        }
        if (!Arrays.equals(this.spanId, other.spanId)) {
            return false;
        }
        if (this.traceFlags != other.traceFlags) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Arrays.hashCode(this.traceId);
        hashCode = 31 * hashCode + Arrays.hashCode(this.spanId);
        hashCode = 31 * hashCode + this.traceFlags;
        return hashCode;
    }

    public TraceContextRecord duplicate() {
        TraceContextRecord _duplicate = new TraceContextRecord();
        _duplicate.traceId = MessageUtil.duplicate((byte[])this.traceId);
        _duplicate.spanId = MessageUtil.duplicate((byte[])this.spanId);
        _duplicate.traceFlags = this.traceFlags;
        return _duplicate;
    }

    public String toString() {
        return "TraceContextRecord(traceId=" + Arrays.toString(this.traceId) + ", spanId=" + Arrays.toString(this.spanId) + ", traceFlags=" + this.traceFlags + ")";
    }

    public byte[] traceId() {
        return this.traceId;
    }

    public byte[] spanId() {
        return this.spanId;
    }

    public byte traceFlags() {
        return this.traceFlags;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public TraceContextRecord setTraceId(byte[] v) {
        this.traceId = v;
        return this;
    }

    public TraceContextRecord setSpanId(byte[] v) {
        this.spanId = v;
        return this;
    }

    public TraceContextRecord setTraceFlags(byte v) {
        this.traceFlags = v;
        return this;
    }
}

