/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.PartitionAssignment;

public class PartitionReassignmentReplicas {
    private final List<Integer> removing;
    private final List<Integer> adding;
    private final List<Integer> replicas;
    private final List<Integer> observers;
    private final List<Integer> removingObservers;
    private final List<Integer> addingObservers;

    public PartitionReassignmentReplicas(List<Integer> removing, List<Integer> adding, List<Integer> replicas, List<Integer> observers, List<Integer> removingObservers, List<Integer> addingObservers) {
        this.removing = removing;
        this.adding = adding;
        this.replicas = replicas;
        this.observers = observers;
        this.removingObservers = removingObservers;
        this.addingObservers = addingObservers;
    }

    public PartitionReassignmentReplicas(List<Integer> removing, List<Integer> adding, List<Integer> replicas) {
        this.removing = removing;
        this.adding = adding;
        this.replicas = replicas;
        this.observers = List.of();
        this.removingObservers = List.of();
        this.addingObservers = List.of();
    }

    private static Set<Integer> calculateDifference(List<Integer> a, List<Integer> b) {
        TreeSet<Integer> result = new TreeSet<Integer>(a);
        result.removeAll(b);
        return result;
    }

    public PartitionReassignmentReplicas(PartitionAssignment currentAssignment, PartitionAssignment targetAssignment) {
        Set<Integer> removing = PartitionReassignmentReplicas.calculateDifference(currentAssignment.replicas(), targetAssignment.replicas());
        this.removing = new ArrayList<Integer>(removing);
        Set<Integer> adding = PartitionReassignmentReplicas.calculateDifference(targetAssignment.replicas(), currentAssignment.replicas());
        this.adding = new ArrayList<Integer>(adding);
        ReplicaLists replicaLists = PartitionReassignmentReplicas.replicaLists(currentAssignment, targetAssignment);
        this.replicas = replicaLists.replicas;
        this.observers = replicaLists.observers;
        this.removingObservers = replicaLists.removingObservers;
        this.addingObservers = replicaLists.addingObservers;
    }

    private static ReplicaLists replicaLists(PartitionAssignment currentAssignment, PartitionAssignment targetAssignment) {
        LinkedHashSet<Integer> replicas = new LinkedHashSet<Integer>();
        replicas.addAll(targetAssignment.syncReplicas());
        ArrayList<Integer> removingSyncReplicas = new ArrayList<Integer>(PartitionReassignmentReplicas.calculateDifference(currentAssignment.syncReplicas(), targetAssignment.syncReplicas()));
        replicas.addAll(removingSyncReplicas);
        replicas.addAll(targetAssignment.observers());
        ArrayList<Integer> removingObservers = new ArrayList<Integer>(PartitionReassignmentReplicas.calculateDifference(currentAssignment.observers(), targetAssignment.observers()));
        replicas.addAll(removingObservers);
        ArrayList<Integer> addingObservers = new ArrayList<Integer>(PartitionReassignmentReplicas.calculateDifference(targetAssignment.observers(), currentAssignment.observers()));
        LinkedHashSet<Integer> observers = new LinkedHashSet<Integer>(targetAssignment.observers());
        observers.addAll(removingObservers);
        return new ReplicaLists(new ArrayList<Integer>(replicas), new ArrayList<Integer>(observers), removingObservers, addingObservers);
    }

    public List<Integer> removing() {
        return this.removing;
    }

    public List<Integer> adding() {
        return this.adding;
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> observers() {
        return this.observers;
    }

    public List<Integer> removingSyncReplicas() {
        List<Integer> result = this.originalSyncReplicas();
        result.removeAll(this.targetSyncReplicas());
        return result;
    }

    public List<Integer> addingSyncReplicas() {
        List<Integer> result = this.targetSyncReplicas();
        result.removeAll(this.originalSyncReplicas());
        return result;
    }

    public static List<Integer> addingSyncReplicas(PartitionRegistration part) {
        return new PartitionReassignmentReplicas(Replicas.toList(part.removingReplicas), Replicas.toList(part.addingReplicas), Replicas.toList(part.replicas), Replicas.toList(part.observers), Replicas.toList(part.removingObservers), Replicas.toList(part.addingObservers)).addingSyncReplicas();
    }

    public List<Integer> removingObservers() {
        return this.removingObservers;
    }

    public List<Integer> addingObservers() {
        return this.addingObservers;
    }

    List<Integer> originalReplicas() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.replicas);
        result.removeAll(this.adding);
        List<Integer> originalObservers = this.originalObservers();
        result.removeAll(originalObservers);
        result.addAll(originalObservers);
        return result;
    }

    List<Integer> originalSyncReplicas() {
        List<Integer> result = this.originalReplicas();
        List<Integer> originalObservers = this.originalObservers();
        result.removeAll(originalObservers);
        return result;
    }

    public List<Integer> originalObservers() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.observers);
        result.removeAll(this.addingObservers);
        return result;
    }

    List<Integer> targetReplicas() {
        List<Integer> targetObservers = this.targetObservers();
        return PartitionReassignmentReplicas.targetReplicas(this.replicas, this.removing, targetObservers);
    }

    public static List<Integer> targetReplicas(List<Integer> replicas, List<Integer> removing, List<Integer> targetObservers) {
        ArrayList<Integer> result = new ArrayList<Integer>(replicas);
        result.removeAll(removing);
        result.removeAll(targetObservers);
        result.addAll(targetObservers);
        return result;
    }

    public static List<Integer> targetReplicas(PartitionRegistration part) {
        List<Integer> targetObservers = PartitionReassignmentReplicas.targetObservers(Replicas.toList(part.observers), Replicas.toList(part.removingObservers));
        return PartitionReassignmentReplicas.targetReplicas(Replicas.toList(part.replicas), Replicas.toList(part.removingReplicas), targetObservers);
    }

    List<Integer> targetSyncReplicas() {
        List<Integer> result = this.targetReplicas();
        List<Integer> targetObservers = this.targetObservers();
        result.removeAll(targetObservers);
        return result;
    }

    public List<Integer> targetObservers() {
        return PartitionReassignmentReplicas.targetObservers(this.observers, this.removingObservers);
    }

    public static List<Integer> targetObservers(List<Integer> observers, List<Integer> removingObservers) {
        ArrayList<Integer> result = new ArrayList<Integer>(observers);
        result.removeAll(removingObservers);
        return result;
    }

    public static boolean isReassignmentInProgress(PartitionRegistration part) {
        return PartitionReassignmentReplicas.isReassignmentInProgress(Replicas.toList(part.removingReplicas), Replicas.toList(part.addingReplicas), Replicas.toList(part.removingObservers), Replicas.toList(part.addingObservers));
    }

    public static boolean isReassignmentInProgress(List<Integer> removingReplicas, List<Integer> addingReplicas, List<Integer> removingObservers, List<Integer> addingObservers) {
        return !removingReplicas.isEmpty() || !addingReplicas.isEmpty() || !removingObservers.isEmpty() || !addingObservers.isEmpty();
    }

    boolean isReassignmentInProgress() {
        return PartitionReassignmentReplicas.isReassignmentInProgress(this.removing, this.adding, this.removingObservers, this.addingObservers);
    }

    Optional<CompletedReassignment> maybeCompleteReassignment(List<Integer> targetIsr) {
        if (!this.isReassignmentInProgress()) {
            return Optional.empty();
        }
        ArrayList<Integer> newTargetIsr = new ArrayList<Integer>(targetIsr);
        if (!this.removing.isEmpty()) {
            newTargetIsr = new ArrayList(targetIsr.size());
            for (int replica : targetIsr) {
                if (this.removing.contains(replica)) continue;
                newTargetIsr.add(replica);
            }
            if (newTargetIsr.isEmpty()) {
                return Optional.empty();
            }
            ArrayList<Integer> newTargetReplicas = new ArrayList<Integer>(this.replicas.size());
            for (int replica : this.replicas) {
                if (this.removing.contains(replica)) continue;
                newTargetReplicas.add(replica);
            }
            if (newTargetReplicas.isEmpty()) {
                return Optional.empty();
            }
        }
        if (!newTargetIsr.containsAll(this.targetSyncReplicas())) {
            return Optional.empty();
        }
        return Optional.of(new CompletedReassignment(this.targetReplicas(), this.targetObservers(), newTargetIsr));
    }

    public int hashCode() {
        return Objects.hash(this.removing, this.adding, this.replicas, this.observers, this.removingObservers, this.addingObservers);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionReassignmentReplicas)) {
            return false;
        }
        PartitionReassignmentReplicas other = (PartitionReassignmentReplicas)o;
        return this.removing.equals(other.removing) && this.adding.equals(other.adding) && this.replicas.equals(other.replicas) && this.observers.equals(other.observers) && this.removingObservers.equals(other.removingObservers) && this.addingObservers.equals(other.addingObservers);
    }

    public String toString() {
        return "PartitionReassignmentReplicas(removing=" + String.valueOf(this.removing) + ", adding=" + String.valueOf(this.adding) + ", replicas=" + String.valueOf(this.replicas) + ", observers=" + String.valueOf(this.observers) + ", removingObservers=" + String.valueOf(this.removingObservers) + ", addingObservers=" + String.valueOf(this.addingObservers) + ")";
    }

    private static class ReplicaLists {
        final List<Integer> replicas;
        final List<Integer> observers;
        final List<Integer> removingObservers;
        final List<Integer> addingObservers;

        public ReplicaLists(List<Integer> replicas, List<Integer> observers, List<Integer> removingObservers, List<Integer> addingObservers) {
            this.replicas = replicas;
            this.observers = observers;
            this.removingObservers = removingObservers;
            this.addingObservers = addingObservers;
        }
    }

    static class CompletedReassignment {
        final List<Integer> replicas;
        final List<Integer> observers;
        final List<Integer> isr;

        public CompletedReassignment(List<Integer> replicas, List<Integer> observers, List<Integer> isr) {
            this.replicas = replicas;
            this.observers = observers;
            this.isr = isr;
        }
    }
}

