/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.node.AclsImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;

public final class AclsImage {
    public static final AclsImage EMPTY = new AclsImage(Map.of());
    private final Map<Uuid, ConfluentStandardAcl> acls;

    public AclsImage(Map<Uuid, ConfluentStandardAcl> acls) {
        this.acls = Collections.unmodifiableMap(acls);
    }

    public boolean isEmpty() {
        return this.acls.isEmpty();
    }

    public Map<Uuid, ConfluentStandardAcl> acls() {
        return this.acls;
    }

    public void write(ImageWriter writer) {
        for (Map.Entry<Uuid, ConfluentStandardAcl> entry : this.acls.entrySet()) {
            StandardAclWithId aclWithId = new StandardAclWithId(entry.getKey(), entry.getValue());
            writer.write(0, aclWithId.toRecord());
        }
    }

    public int hashCode() {
        return this.acls.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AclsImage)) {
            return false;
        }
        AclsImage other = (AclsImage)o;
        return this.acls.equals(other.acls);
    }

    public String toString() {
        return new AclsImageNode(this).stringify();
    }
}

