/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkChangeRecord;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.image.ClusterLinkDelta;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.metadata.ClusterLink;

public class ClusterLinksDelta {
    private final ClusterLinksImage image;
    private final Set<Uuid> addedClusterLinks;
    private final Map<Uuid, ClusterLinkDelta> changedClusterLinks;
    private final Set<Uuid> deletedClusterLinks;

    public ClusterLinksDelta(ClusterLinksImage image) {
        this.image = image;
        this.addedClusterLinks = new HashSet<Uuid>();
        this.deletedClusterLinks = new HashSet<Uuid>();
        this.changedClusterLinks = new HashMap<Uuid, ClusterLinkDelta>();
    }

    public void replay(ClusterLinkRecord record) {
        ClusterLinkDelta clusterLinkDelta = new ClusterLinkDelta(new ClusterLink(record));
        clusterLinkDelta.replay(record);
        this.changedClusterLinks.put(record.clusterLinkId(), clusterLinkDelta);
        this.addedClusterLinks.add(record.clusterLinkId());
    }

    private ClusterLinkDelta getOrCreateClusterLinkDelta(ClusterLinkChangeRecord record) {
        Uuid linkId = record.clusterLinkId();
        ClusterLinkDelta clusterLinkDelta = this.changedClusterLinks.get(linkId);
        if (clusterLinkDelta == null) {
            ClusterLink clusterLink = this.image.linksById().get(linkId);
            if (clusterLink == null) {
                throw new RuntimeException("Cannot change unknown ClusterLink with LinkId: " + String.valueOf(linkId) + "LinkName: " + record.clusterLinkName());
            }
            clusterLinkDelta = new ClusterLinkDelta(clusterLink);
            this.changedClusterLinks.put(linkId, clusterLinkDelta);
        }
        return clusterLinkDelta;
    }

    public void replay(ClusterLinkChangeRecord record) {
        ClusterLinkDelta clusterLinkDelta = this.getOrCreateClusterLinkDelta(record);
        clusterLinkDelta.replay(record);
    }

    public void replay(RemoveClusterLinkRecord removeRecord) {
        Uuid removedClusterLinkId = removeRecord.clusterLinkId();
        if (this.changedClusterLinks.remove(removedClusterLinkId) != null) {
            if (this.image.linksById().containsKey(removedClusterLinkId)) {
                this.deletedClusterLinks.add(removedClusterLinkId);
            }
        } else {
            if (!this.image.linksById().containsKey(removedClusterLinkId)) {
                throw new RuntimeException("Cannot remove unknown ClusterLink " + String.valueOf(removedClusterLinkId));
            }
            this.deletedClusterLinks.add(removedClusterLinkId);
        }
    }

    public ClusterLinksImage apply() {
        HashMap<String, ClusterLink> newLinksByName = new HashMap<String, ClusterLink>(this.image.linksByName().size());
        HashMap<Uuid, ClusterLink> newLinksById = new HashMap<Uuid, ClusterLink>(this.image.linksById().size());
        this.image.linksById().forEach((linkId, clusterLink) -> {
            if (!this.deletedClusterLinks.contains(linkId)) {
                newLinksByName.put(clusterLink.linkName(), (ClusterLink)clusterLink);
                newLinksById.put((Uuid)linkId, (ClusterLink)clusterLink);
            }
        });
        this.changedClusterLinks.forEach((linkId, clusterLink) -> {
            newLinksByName.put(clusterLink.linkName(), clusterLink.apply());
            newLinksById.put((Uuid)linkId, clusterLink.apply());
        });
        return new ClusterLinksImage(newLinksById, newLinksByName, Map.of());
    }

    public void finishSnapshot() {
        for (Uuid linkId : this.image.linksById().keySet()) {
            if (this.changedClusterLinks.containsKey(linkId)) continue;
            this.deletedClusterLinks.add(linkId);
        }
    }

    public Set<Uuid> deletedClusterLinks() {
        return this.deletedClusterLinks;
    }

    public Map<Uuid, ClusterLinkDelta> changedClusterLinks() {
        return this.changedClusterLinks;
    }

    public Set<Uuid> addedClusterLinks() {
        return this.addedClusterLinks;
    }

    public String toString() {
        return "ClusterLinksDelta(addedClusterLinks=" + String.valueOf(this.addedClusterLinks) + "changedClusterLinks=" + String.valueOf(this.changedClusterLinks) + ", deletedClusterLinks=" + String.valueOf(this.deletedClusterLinks) + ")";
    }
}

