/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.ClusterLink;

public class ClusterLinkMetadata {
    private final String linkName;
    private final Uuid linkId;
    private final Optional<String> clusterId;
    private final Optional<String> tenantPrefix;
    private final Optional<String> linkPrefix;
    private final Properties linkProperties;

    public ClusterLinkMetadata(String linkName, Uuid linkId, Optional<String> clusterId, Optional<String> tenantPrefix, Optional<String> linkPrefix, Properties linkProperties) {
        this.linkName = linkName;
        this.linkId = linkId;
        this.clusterId = clusterId;
        this.tenantPrefix = tenantPrefix;
        this.linkPrefix = linkPrefix;
        this.linkProperties = linkProperties;
    }

    private static Properties mapToProperties(Map<String, String> propsMap) {
        Properties props = new Properties();
        props.putAll(propsMap);
        return props;
    }

    public ClusterLinkMetadata(ClusterLink clusterLinkImage, Map<String, String> linkProperties) {
        this(clusterLinkImage, ClusterLinkMetadata.mapToProperties(linkProperties));
    }

    public ClusterLinkMetadata(ClusterLink clusterLinkImage, Properties linkProperties) {
        this(clusterLinkImage.linkName(), clusterLinkImage.linkId(), Optional.of(clusterLinkImage.remoteClusterId()), clusterLinkImage.tenantPrefix(), Optional.ofNullable(linkProperties.getProperty("cluster.link.prefix")), linkProperties);
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Optional<String> clusterId() {
        return this.clusterId;
    }

    public Optional<String> tenantPrefix() {
        return this.tenantPrefix;
    }

    public Optional<String> linkPrefix() {
        return this.linkPrefix;
    }

    public Properties linkProperties() {
        return this.linkProperties;
    }
}

