/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.EncryptedEnvelopeRecord;
import org.apache.kafka.common.metadata.InstallMetadataEncryptorRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineObject;
import org.slf4j.Logger;

public class EncryptionControlManager {
    private final Logger log;
    private final TimelineObject<MetadataEncryptor> encryptor;
    private final Supplier<MetadataEncryptorFactory> metadataEncryptorFactorySupplier;
    private final Boolean isEncryptorRequired;
    private QuorumControllerMetrics metrics;

    private EncryptionControlManager(LogContext logContext, SnapshotRegistry snapshotRegistry, Supplier<MetadataEncryptorFactory> encryptorFactorySupplier, QuorumControllerMetrics metrics, Boolean isEncryptorRequired) {
        this.log = logContext.logger(EncryptionControlManager.class);
        this.encryptor = new TimelineObject(snapshotRegistry, (Object)NoOpMetadataEncryptor.INSTANCE);
        this.metadataEncryptorFactorySupplier = encryptorFactorySupplier;
        this.metrics = metrics;
        this.isEncryptorRequired = isEncryptorRequired;
    }

    public void replay(InstallMetadataEncryptorRecord record) {
        MetadataEncryptorFactory factory = this.metadataEncryptorFactorySupplier.get();
        MetadataEncryptor newEncryptor = factory.createFromConfig(record);
        this.encryptor.set((Object)newEncryptor);
        this.log.info("Replayed InstallMetadataEncryptorRecord with id {}, class {}", (Object)record.keyId(), (Object)this.encryptor.getClass().getSimpleName());
        this.metrics.installNewEncryptor(record.keyId(), factory.getCreateTimeMillisSinceEpoch(record.keyId()));
    }

    public ApiMessageAndVersion decrypt(EncryptedEnvelopeRecord record) {
        return ((MetadataEncryptor)this.encryptor.get()).decrypt(record);
    }

    public MetadataEncryptor encryptor() {
        return (MetadataEncryptor)this.encryptor.get();
    }

    public MetadataEncryptor encryptor(long epoch) {
        return (MetadataEncryptor)this.encryptor.get(epoch);
    }

    public Boolean isEncryptorRequired() {
        return this.isEncryptorRequired;
    }

    Uuid activeEncryptorId() {
        return ((MetadataEncryptor)this.encryptor.get()).id();
    }

    public Supplier<MetadataEncryptorFactory> getMetadataEncryptorFactorySupplier() {
        return this.metadataEncryptorFactorySupplier;
    }

    EncryptionControlIterator iterator(long epoch) {
        return new EncryptionControlIterator(((MetadataEncryptor)this.encryptor.get(epoch)).id());
    }

    class EncryptionControlIterator
    implements Iterator<List<ApiMessageAndVersion>> {
        private Uuid id;

        EncryptionControlIterator(Uuid id) {
            this.id = id;
        }

        @Override
        public boolean hasNext() {
            return this.id != null;
        }

        @Override
        public List<ApiMessageAndVersion> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            List<ApiMessageAndVersion> result = List.of(new ApiMessageAndVersion((ApiMessage)new InstallMetadataEncryptorRecord().setKeyId(this.id), 0));
            this.id = null;
            return result;
        }
    }

    static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private Supplier<MetadataEncryptorFactory> encryptorFactorySupplier = () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY;
        private QuorumControllerMetrics metrics = null;
        private Boolean isEncryptorRequired = false;

        Builder() {
        }

        Builder setLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder setSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder setEncryptorFactorySupplier(Supplier<MetadataEncryptorFactory> encryptorFactorySupplier) {
            this.encryptorFactorySupplier = encryptorFactorySupplier;
            return this;
        }

        Builder setMetrics(QuorumControllerMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        Builder setIsEncryptorRequired(Boolean encryptorRequired) {
            this.isEncryptorRequired = encryptorRequired;
            return this;
        }

        EncryptionControlManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.metrics == null) {
                this.metrics = new QuorumControllerMetrics(Optional.empty(), Time.SYSTEM, new Metrics(), 0);
            }
            return new EncryptionControlManager(this.logContext, this.snapshotRegistry, this.encryptorFactorySupplier, this.metrics, this.isEncryptorRequired);
        }
    }
}

