/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.controller.metrics.BrokerRegistrationState;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControllerMetadataMetrics
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerMetadataMetrics.class);
    private static final MetricName FENCED_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "FencedBrokerCount");
    private static final MetricName ACTIVE_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "ActiveBrokerCount");
    private static final MetricName CONTROLLED_SHUTDOWN_BROKER_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "ControlledShutdownBrokerCount");
    private static final String BROKER_REGISTRATION_STATE_METRIC_NAME = "BrokerRegistrationState";
    private static final String BROKER_ID_TAG = "broker";
    private static final MetricName METADATA_ERROR_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "MetadataErrorCount");
    private static final MetricName BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "BrokersExcludedForReplicaPlacementCount");
    private static final MetricName BROKERS_WITH_DEGRADED_HEALTH_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "BrokersWithDegradedHealthCount");
    private static final MetricName BROKERS_WITH_DEGRADED_STORAGE_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "BrokersWithDegradedStorageCount");
    private static final MetricName BROKERS_WITH_DEGRADED_NETWORK_COUNT = ControllerMetadataMetrics.getMetricName("KafkaController", "BrokersWithDegradedNetworkCount");
    private static final MetricName IGNORED_STATIC_VOTERS = ControllerMetadataMetrics.getMetricName("KafkaController", "IgnoredStaticVoters");
    private final Optional<MetricsRegistry> registry;
    private final AtomicInteger fencedBrokerCount = new AtomicInteger(0);
    private final AtomicInteger activeBrokerCount = new AtomicInteger(0);
    private final AtomicInteger brokersWithDegradedHealthCount = new AtomicInteger(0);
    private final AtomicInteger brokersWithDegradedStorageCount = new AtomicInteger(0);
    private final AtomicInteger brokersWithDegradedNetworkCount = new AtomicInteger(0);
    private final AtomicInteger excludedBrokerCount = new AtomicInteger(0);
    private final AtomicInteger controllerShutdownBrokerCount = new AtomicInteger(0);
    private final Map<Integer, Integer> brokerRegistrationStates = new ConcurrentHashMap<Integer, Integer>();
    private final AtomicInteger metadataErrorCount = new AtomicInteger(0);
    private final AtomicInteger zkMigrationState = new AtomicInteger(-1);
    private final AtomicBoolean ignoredStaticVoters = new AtomicBoolean(false);
    private final Map<Integer, AtomicInteger> degradedBrokerGauges = new ConcurrentHashMap<Integer, AtomicInteger>();

    public ControllerMetadataMetrics(Optional<MetricsRegistry> registry) {
        this.registry = registry;
        registry.ifPresent(r -> r.newGauge(FENCED_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.fencedBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(ACTIVE_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.activeBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(CONTROLLED_SHUTDOWN_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.controlledShutdownBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(METADATA_ERROR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.metadataErrorCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(BROKERS_WITH_DEGRADED_HEALTH_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.brokersWithDegradedHealthCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(BROKERS_WITH_DEGRADED_STORAGE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.brokersWithDegradedStorageCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(BROKERS_WITH_DEGRADED_NETWORK_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.brokersWithDegradedNetworkCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.excludedBrokerCount();
            }
        }));
        registry.ifPresent(r -> r.newGauge(IGNORED_STATIC_VOTERS, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return ControllerMetadataMetrics.this.ignoredStaticVoters() ? 1 : 0;
            }
        }));
    }

    public void addBrokerRegistrationStateMetric(final int brokerId) {
        this.registry.ifPresent(r -> r.newGauge(ControllerMetadataMetrics.getBrokerIdTagMetricName("KafkaController", BROKER_REGISTRATION_STATE_METRIC_NAME, brokerId), (Gauge)new Gauge<Integer>(this){
            final /* synthetic */ ControllerMetadataMetrics this$0;
            {
                this.this$0 = this$0;
            }

            public Integer value() {
                return this.this$0.brokerRegistrationState(brokerId);
            }
        }));
    }

    public void removeBrokerRegistrationStateMetric(int brokerId) {
        this.registry.ifPresent(r -> r.removeMetric(ControllerMetadataMetrics.getBrokerIdTagMetricName("KafkaController", BROKER_REGISTRATION_STATE_METRIC_NAME, brokerId)));
    }

    public Optional<MetricsRegistry> registry() {
        return this.registry;
    }

    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokerCount.set(brokerCount);
    }

    public void addToFencedBrokerCount(int brokerCountDelta) {
        this.fencedBrokerCount.addAndGet(brokerCountDelta);
    }

    public int fencedBrokerCount() {
        return this.fencedBrokerCount.get();
    }

    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokerCount.set(brokerCount);
    }

    public void addToActiveBrokerCount(int brokerCountDelta) {
        this.activeBrokerCount.addAndGet(brokerCountDelta);
    }

    public int activeBrokerCount() {
        return this.activeBrokerCount.get();
    }

    public void setBrokersWithDegradedHealthCount(int count) {
        this.brokersWithDegradedHealthCount.set(count);
    }

    public void setControlledShutdownBrokerCount(int brokerCount) {
        this.controllerShutdownBrokerCount.set(brokerCount);
    }

    public void addToControlledShutdownBrokerCount(int brokerCountDelta) {
        this.controllerShutdownBrokerCount.addAndGet(brokerCountDelta);
    }

    public int controlledShutdownBrokerCount() {
        return this.controllerShutdownBrokerCount.get();
    }

    public void setBrokerRegistrationState(int brokerId, BrokerRegistration brokerRegistration) {
        if (brokerRegistration == null) {
            this.removeBrokerRegistrationStateMetric(brokerId);
            this.brokerRegistrationStates.remove(brokerId);
            return;
        }
        BrokerRegistrationState brokerState = BrokerRegistrationState.getBrokerRegistrationState(brokerRegistration);
        this.brokerRegistrationStates.put(brokerId, brokerState.state());
    }

    public int brokerRegistrationState(int brokerId) {
        return this.brokerRegistrationStates.getOrDefault(brokerId, BrokerRegistrationState.UNREGISTERED.state());
    }

    public void addToBrokersWithDegradedHealthCount(int delta) {
        this.brokersWithDegradedHealthCount.addAndGet(delta);
    }

    public int brokersWithDegradedHealthCount() {
        return this.brokersWithDegradedHealthCount.get();
    }

    public void setBrokersWithDegradedStorageCount(int count) {
        if (count < 0) {
            LOG.warn("Attempting to mark number of brokers with degraded storage to a negative value({}), setting to 0 instead. Number of brokers that were degraded on STORAGE: {}", (Object)count, (Object)this.brokersWithDegradedStorageCount());
            this.brokersWithDegradedStorageCount.set(0);
        } else {
            this.brokersWithDegradedStorageCount.set(count);
        }
    }

    public void addToBrokersWithDegradedStorageCount(int delta) {
        this.setBrokersWithDegradedStorageCount(this.brokersWithDegradedStorageCount() + delta);
    }

    public int brokersWithDegradedStorageCount() {
        return this.brokersWithDegradedStorageCount.get();
    }

    public void setBrokersWithDegradedNetworkCount(int count) {
        if (count < 0) {
            LOG.warn("Attempting to mark number of brokers with degraded network to a negative value({}), setting to 0 instead. Number of brokers that were degraded on NETWORK: {}", (Object)count, (Object)this.brokersWithDegradedNetworkCount());
            this.brokersWithDegradedNetworkCount.set(0);
        } else {
            this.brokersWithDegradedNetworkCount.set(count);
        }
    }

    public void addToBrokersWithDegradedNetworkCount(int delta) {
        this.setBrokersWithDegradedNetworkCount(this.brokersWithDegradedNetworkCount() + delta);
    }

    public int brokersWithDegradedNetworkCount() {
        return this.brokersWithDegradedNetworkCount.get();
    }

    public void setExcludedBrokerCount(int count) {
        this.excludedBrokerCount.set(count);
    }

    public void addToExcludedBrokerCount(int delta) {
        this.excludedBrokerCount.addAndGet(delta);
    }

    public int excludedBrokerCount() {
        return this.excludedBrokerCount.get();
    }

    public void incrementMetadataErrorCount() {
        this.metadataErrorCount.getAndIncrement();
    }

    public int metadataErrorCount() {
        return this.metadataErrorCount.get();
    }

    public void setIgnoredStaticVoters(boolean ignored) {
        this.ignoredStaticVoters.set(ignored);
    }

    public boolean ignoredStaticVoters() {
        return this.ignoredStaticVoters.get();
    }

    private static MetricName degradedBrokerMetricName(int brokerId) {
        LinkedHashMap<String, CallSite> tags = new LinkedHashMap<String, CallSite>();
        String kafkaPodName = "kafka-" + brokerId;
        tags.put("brokerId", (CallSite)((Object)kafkaPodName));
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)"KafkaController", (String)"BrokerWithDegradedHealth", tags);
    }

    public void setBrokerDegraded(int brokerId, boolean degraded) {
        AtomicInteger value = this.degradedBrokerGauges.computeIfAbsent(brokerId, id -> {
            this.registry.ifPresent(r -> r.newGauge(ControllerMetadataMetrics.degradedBrokerMetricName(id), (Gauge)new Gauge<Integer>(this){
                final /* synthetic */ ControllerMetadataMetrics this$0;
                {
                    this.this$0 = this$0;
                }

                public Integer value() {
                    AtomicInteger current = this.this$0.degradedBrokerGauges.get(id);
                    return current != null ? current.get() : 0;
                }
            }));
            return new AtomicInteger(0);
        });
        value.set(degraded ? 1 : 0);
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> List.of(FENCED_BROKER_COUNT, ACTIVE_BROKER_COUNT, CONTROLLED_SHUTDOWN_BROKER_COUNT, METADATA_ERROR_COUNT, BROKERS_EXCLUDED_FOR_REPLICA_PLACEMENT_COUNT, BROKERS_WITH_DEGRADED_HEALTH_COUNT, BROKERS_WITH_DEGRADED_STORAGE_COUNT, BROKERS_WITH_DEGRADED_NETWORK_COUNT, IGNORED_STATIC_VOTERS).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
        this.registry.ifPresent(r -> this.degradedBrokerGauges.keySet().forEach(id -> r.removeMetric(ControllerMetadataMetrics.degradedBrokerMetricName(id))));
        this.degradedBrokerGauges.clear();
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }

    private static MetricName getBrokerIdTagMetricName(String type, String name, int brokerId) {
        LinkedHashMap<String, String> brokerIdTag = new LinkedHashMap<String, String>();
        brokerIdTag.put(BROKER_ID_TAG, Integer.toString(brokerId));
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name, brokerIdTag);
    }
}

