/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.node.MetadataLeafNode;
import org.apache.kafka.image.node.MetadataNode;

public class LinkNamesByTenantNode
implements MetadataNode {
    public static final String NAME = "linkNamesByTenant";
    private final ClusterLinksImage image;

    public LinkNamesByTenantNode(ClusterLinksImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        return this.image.linkNamesByTenant().keySet();
    }

    @Override
    public MetadataNode child(String name) {
        Set<String> linkNames = this.image.linkNamesByTenant().get(name);
        if (linkNames == null) {
            return null;
        }
        ArrayList<String> sortedLinkNames = new ArrayList<String>(linkNames);
        sortedLinkNames.sort(String::compareTo);
        return new MetadataLeafNode(String.join((CharSequence)", ", sortedLinkNames));
    }
}

