/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.placement.DefaultDirProvider;

public class PartitionAssignment {
    private final List<Integer> replicas;
    private final List<Integer> observers;
    private final List<Uuid> directories;

    public PartitionAssignment(List<Integer> replicas, List<Integer> observers, DefaultDirProvider defaultDirProvider) {
        this.replicas = List.copyOf(replicas);
        this.observers = List.copyOf(observers);
        this.directories = replicas.stream().map(replica -> defaultDirProvider.defaultDir((int)replica)).toList();
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> observers() {
        return this.observers;
    }

    public List<Uuid> directories() {
        return this.directories;
    }

    public List<Integer> syncReplicas() {
        HashSet<Integer> observersSet = new HashSet<Integer>(this.observers);
        return this.replicas.stream().filter(x -> !observersSet.contains(x)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionAssignment that = (PartitionAssignment)o;
        return Objects.equals(this.replicas, that.replicas) && Objects.equals(this.observers, that.observers) && Objects.equals(this.directories, that.directories);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.observers, this.directories);
    }

    public String toString() {
        return "PartitionAssignment(replicas=" + String.valueOf(this.replicas) + ", observers=" + String.valueOf(this.observers) + ", directories=" + String.valueOf(this.directories) + ")";
    }
}

