/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.server.share.persister.DeleteShareGroupStateParameters;
import org.apache.kafka.server.share.persister.DeleteShareGroupStateResult;
import org.apache.kafka.server.share.persister.GroupTopicPartitionData;
import org.apache.kafka.server.share.persister.InitializeShareGroupStateParameters;
import org.apache.kafka.server.share.persister.InitializeShareGroupStateResult;
import org.apache.kafka.server.share.persister.PartitionAllData;
import org.apache.kafka.server.share.persister.PartitionErrorData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionIdData;
import org.apache.kafka.server.share.persister.PartitionIdLeaderEpochData;
import org.apache.kafka.server.share.persister.PartitionStateBatchData;
import org.apache.kafka.server.share.persister.PartitionStateData;
import org.apache.kafka.server.share.persister.PartitionStateSummaryData;
import org.apache.kafka.server.share.persister.Persister;
import org.apache.kafka.server.share.persister.ReadShareGroupStateParameters;
import org.apache.kafka.server.share.persister.ReadShareGroupStateResult;
import org.apache.kafka.server.share.persister.ReadShareGroupStateSummaryParameters;
import org.apache.kafka.server.share.persister.ReadShareGroupStateSummaryResult;
import org.apache.kafka.server.share.persister.TopicData;
import org.apache.kafka.server.share.persister.WriteShareGroupStateParameters;
import org.apache.kafka.server.share.persister.WriteShareGroupStateResult;

public class NoOpShareStatePersister
implements Persister {
    @Override
    public CompletableFuture<InitializeShareGroupStateResult> initializeState(InitializeShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionStateData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionErrorData>> resultArgs = new ArrayList<TopicData<PartitionErrorData>>();
        for (TopicData<PartitionStateData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(partStateData -> PartitionFactory.newPartitionErrorData(partStateData.partition(), PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new InitializeShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<ReadShareGroupStateResult> readState(ReadShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionIdLeaderEpochData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionAllData>> resultArgs = new ArrayList<TopicData<PartitionAllData>>();
        for (TopicData<PartitionIdLeaderEpochData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(partitionIdData -> PartitionFactory.newPartitionAllData(partitionIdData.partition(), 0, -1L, PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE, Collections.emptyList())).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new ReadShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<WriteShareGroupStateResult> writeState(WriteShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionStateBatchData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionErrorData>> resultArgs = new ArrayList<TopicData<PartitionErrorData>>();
        for (TopicData<PartitionStateBatchData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(batch -> PartitionFactory.newPartitionErrorData(batch.partition(), PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new WriteShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<DeleteShareGroupStateResult> deleteState(DeleteShareGroupStateParameters request) {
        GroupTopicPartitionData<PartitionIdData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionErrorData>> resultArgs = new ArrayList<TopicData<PartitionErrorData>>();
        for (TopicData<PartitionIdData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(batch -> PartitionFactory.newPartitionErrorData(batch.partition(), PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new DeleteShareGroupStateResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public CompletableFuture<ReadShareGroupStateSummaryResult> readSummary(ReadShareGroupStateSummaryParameters request) {
        GroupTopicPartitionData<PartitionIdLeaderEpochData> reqData = request.groupTopicPartitionData();
        ArrayList<TopicData<PartitionStateSummaryData>> resultArgs = new ArrayList<TopicData<PartitionStateSummaryData>>();
        for (TopicData<PartitionIdLeaderEpochData> topicData : reqData.topicsData()) {
            resultArgs.add(new TopicData(topicData.topicId(), topicData.partitions().stream().map(partitionIdData -> PartitionFactory.newPartitionStateSummaryData(partitionIdData.partition(), 0, -1L, PartitionFactory.DEFAULT_ERROR_CODE, PartitionFactory.DEFAULT_ERR_MESSAGE)).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(new ReadShareGroupStateSummaryResult.Builder().setTopicsData(resultArgs).build());
    }

    @Override
    public void stop() {
    }
}

