/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidRequestException;

public class ClusterLinkUtils {
    public static void validateLinkNameOrThrow(Optional<String> tenantPrefixOpt, String linkName) {
        String linkNameToValidate = ClusterLinkUtils.linkNameToValidate(tenantPrefixOpt, linkName);
        ClusterLinkUtils.validateLinkNameOrThrow(linkNameToValidate);
    }

    public static void validateLinkNameOrThrow(String linkName) {
        int maxLength = 200;
        if (linkName == null) {
            throw new InvalidClusterLinkException("Cluster link name is null");
        }
        if (linkName.isEmpty()) {
            throw new InvalidClusterLinkException("Cluster link name is empty");
        }
        if (linkName.equals(".") || linkName.equals("..")) {
            throw new InvalidClusterLinkException("Link name cannot be \".\" or \"..\"");
        }
        if (linkName.length() > 200) {
            throw new InvalidClusterLinkException("Link name exceeds maximum size of '200' characters");
        }
        boolean isValid = linkName.chars().allMatch(c -> c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 46 || c == 95 || c == 45);
        if (!isValid) {
            throw new InvalidClusterLinkException("Link name '" + linkName + "' is illegal, valid characters: [a-zA-Z0-9._-]");
        }
    }

    private static String linkNameToValidate(Optional<String> tenantPrefixOpt, String linkName) {
        String linkNameToValidate;
        if (tenantPrefixOpt.isPresent()) {
            String tenantPrefix = tenantPrefixOpt.get();
            if (linkName == null || !linkName.startsWith(tenantPrefix)) {
                throw new IllegalStateException("Link name " + linkName + " doesn't start with tenant prefix " + tenantPrefix);
            }
            linkNameToValidate = linkName.substring(tenantPrefix.length());
        } else {
            linkNameToValidate = linkName;
        }
        return linkNameToValidate;
    }

    public static boolean containsReverseAndSwapOpCode(Set<Byte> opCodes) {
        return opCodes.contains(AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR.id()) || opCodes.contains(AlterMirrorOp.REVERSE_AND_PAUSE_REMOTE_MIRROR.id());
    }

    public static boolean containsRestoreOpCode(Set<Byte> opCodes) {
        return opCodes.contains(AlterMirrorOp.TRUNCATE_AND_RESTORE.id()) || opCodes.contains(AlterMirrorOp.CONVERT_TO_PENDING_RESTORE_MIRROR.id()) || opCodes.contains(AlterMirrorOp.START_PENDING_RESTORE_MIRROR.id());
    }

    public static boolean containsUpdateSwitchoverMetadataOpCode(Set<Byte> opCodes) {
        return opCodes.contains(AlterMirrorOp.UPDATE_SWITCHOVER_METADATA.id());
    }

    public static void ensureValidUuid(String idType, Uuid uuid, String exceptionMessage) {
        if (uuid == null || uuid == Uuid.ZERO_UUID) {
            throw new InvalidRequestException(idType + " cannot be null or zero UUID." + exceptionMessage);
        }
    }
}

