/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.ZoneAlignment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneUtils {
    private static final Logger log = LoggerFactory.getLogger(ZoneUtils.class);

    public static ZoneAlignment validateZoneAlignment(Set<String> rackSet, String brokerRack, String clientRack) {
        if (rackSet.isEmpty() || brokerRack == null || !rackSet.contains(brokerRack)) {
            log.error("Rack set {} does not contain broker rack {}", rackSet, (Object)brokerRack);
            return ZoneAlignment.UNKNOWN;
        }
        if (!rackSet.contains(clientRack)) {
            return ZoneAlignment.UNKNOWN;
        }
        if (brokerRack.equals(clientRack)) {
            return ZoneAlignment.SAME_ZONE;
        }
        return ZoneAlignment.CROSS_ZONE;
    }

    public static Set<String> getValidBrokerRackSet(String rackList) {
        if (rackList == null || rackList.trim().equals("")) {
            return new HashSet<String>();
        }
        String[] splitRackList = rackList.trim().split(",");
        return new HashSet<String>(List.of(splitRackList));
    }

    public static boolean isFetchFromFollowerEnabled(String replicaSelectorClass, String brokerRack, Set<String> validBrokerRackSet) {
        return replicaSelectorClass != null && brokerRack != null && !validBrokerRackSet.isEmpty();
    }
}

