/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TopicType {
    UNKNOWN(-1),
    STANDARD(0),
    FREIGHT(1),
    VIRTUAL(2);

    private static final Map<Byte, TopicType> TOPIC_TYPES_BY_ID;
    private static final Map<TopicType, String> LOG_CONFIG_VALUES_BY_TOPIC_TYPE;
    private static final Map<String, TopicType> TOPIC_TYPES_BY_LOG_CONFIG_VALUE;
    private final byte id;

    private TopicType(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public String logConfigValue() {
        return LOG_CONFIG_VALUES_BY_TOPIC_TYPE.get((Object)this);
    }

    public static TopicType forIdOrThrow(byte id) {
        TopicType topicType = TopicType.forId(id);
        if (topicType.equals((Object)UNKNOWN)) {
            throw new IllegalStateException("No topic type for id (should not happen): " + id);
        }
        return topicType;
    }

    public static TopicType forId(byte id) {
        return TOPIC_TYPES_BY_ID.getOrDefault(id, UNKNOWN);
    }

    public static TopicType forLogConfigValueOrThrow(String logConfigValue) {
        Optional<TopicType> topicType = TopicType.forLogConfigValue(logConfigValue);
        if (!topicType.isPresent() || topicType.get().equals((Object)UNKNOWN)) {
            throw new IllegalStateException("Unknown topic type for log config value: " + logConfigValue);
        }
        return topicType.get();
    }

    public static Optional<TopicType> forLogConfigValue(String logConfigValue) {
        if (logConfigValue == null || logConfigValue.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TOPIC_TYPES_BY_LOG_CONFIG_VALUE.getOrDefault(logConfigValue, UNKNOWN));
    }

    static {
        TOPIC_TYPES_BY_ID = Collections.unmodifiableMap(Arrays.stream(TopicType.values()).collect(Collectors.toMap(TopicType::id, Function.identity())));
        LOG_CONFIG_VALUES_BY_TOPIC_TYPE = Collections.unmodifiableMap(Arrays.stream(TopicType.values()).collect(Collectors.toMap(Function.identity(), value -> value.name().toLowerCase(Locale.ROOT))));
        TOPIC_TYPES_BY_LOG_CONFIG_VALUE = Collections.unmodifiableMap(Arrays.stream(TopicType.values()).collect(Collectors.toMap(value -> value.name().toLowerCase(Locale.ROOT), Function.identity())));
    }
}

